package com.xebialabs.deployit.plugin.trigger;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.api.validation.Validator;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.Map;

@Retention(RetentionPolicy.RUNTIME)
@Rule(clazz = TriggerValidator.Validator.class, type = "trigger")
@Target(ElementType.TYPE)
public @interface TriggerValidator  {

    public static class Validator implements com.xebialabs.deployit.plugin.api.validation.Validator<Trigger> {

            @Override
        public void validate(Trigger trigger, ValidationContext context) {
            if (!isRequiredValuesFilled(trigger, context)) {
                return;
            }

            if (trigger instanceof StepTrigger) {
                StepTrigger stepTrigger = (StepTrigger) trigger;
                if (!stepTrigger.getFromState().isValidTransition(stepTrigger.getToState())) {
                    context.error("Not a valid step state transition. %s cannot transition to %s", stepTrigger.getFromState(), stepTrigger.getToState());
                }
            } else {
                TaskTrigger taskTrigger = (TaskTrigger) trigger;
                if (!taskTrigger.getFromState().isValidTransition(taskTrigger.getToState())) {
                    context.error("Not a valid task state transition. %s cannot transition to %s", taskTrigger.getFromState(), taskTrigger.getToState());
                }
            }
        }

        private boolean isRequiredValuesFilled(Trigger trigger, ValidationContext context) {
            boolean isRequiredValuesFilled = true;
            if (trigger.getFromState() == null) {
                context.error("FromState value is required");
                isRequiredValuesFilled = false;
            }

            if (trigger.getToState() == null) {
                context.error("ToState value is required");
                isRequiredValuesFilled = false;
            }
            return isRequiredValuesFilled;
        }
    }
}
