package com.xebialabs.deployit.plugin.trigger;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.trigger.action.EmailNotification;

import static com.google.common.base.Strings.isNullOrEmpty;

@Retention(RetentionPolicy.RUNTIME)
@Rule(clazz = BodyValidator.Validator.class, type = "body")
@Target(ElementType.TYPE)
public @interface BodyValidator {

    public static class Validator implements com.xebialabs.deployit.plugin.api.validation.Validator<EmailNotification> {

        @Override
        public void validate(EmailNotification notification, ValidationContext context) {
            if (isNullOrEmpty(notification.getBody()) && isNullOrEmpty(notification.getBodyTemplatePath())) {
                context.error("Both body and bodyTemplatePath are empty, please supply one of the two.");
            }
        }

    }
}
