package com.xebialabs.deployit.plugin.cloud.vsphere.ci;

import java.util.List;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plugin.cloud.vsphere.steps.ValidateVSphereCredentialsStep;

import static java.util.Arrays.asList;

/**
 * Reusable credentials for VSphere
 */
@Metadata(description = "vCenter credentials", root = Metadata.ConfigurationItemRoot.CONFIGURATION)
public class Credentials extends BaseConfigurationItem {

    @Property(required = true, label = "URL", description = "vCenter URL, e.g. https://vcenter.example.com/sdk")
    private String url;

    @Property(required = true, label = "User name", description = "vCenter username.")
    private String username;

    @Property(required = true, password = true, label = "Password", description = "vCenter password.")
    private String password;

    @Property(defaultValue = "true", label = "Ignore SSL certificate warnings")
    private boolean ignoreCert;

    @ControlTask(label = "Validate credentials", description = "Validate credentials by connecting to vCenter.")
    public List<Step> validateCredentials() {
        return asList(
                (Step) new ValidateVSphereCredentialsStep(this)
        );
    }

    public String getUrl() {
        return url;
    }

    public String getUsername() {
        return username;
    }

    public String getPassword() {
        return password;
    }

    public void setUrl(final String url) {
        this.url = url;
    }

    public void setUsername(final String username) {
        this.username = username;
    }

    public void setPassword(final String password) {
        this.password = password;
    }

    public boolean isIgnoreCert() {
        return ignoreCert;
    }

    public void setIgnoreCert(final boolean ignoreCert) {
        this.ignoreCert = ignoreCert;
    }
}
