package com.xebialabs.deployit.plugin.cloud.vsphere.steps;

import java.util.ArrayList;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualMachine;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.cloud.vsphere.access.VsphereAdapter;
import com.xebialabs.deployit.plugin.cloud.vsphere.ci.HostTemplate;

import static com.xebialabs.deployit.plugin.cloud.step.ContextAttribute.STARTED_TASKS;
import static com.xebialabs.deployit.plugin.cloud.util.ContextHelper.wrapped;
import static java.util.Arrays.asList;

public class DestroyInstanceStep implements Step {

    private String cloudId;
    private HostTemplate template;

    private VsphereAdapter adapter;

    public DestroyInstanceStep(final ConfigurationItem instance, final VsphereAdapter adapter) {
        cloudId = instance.getProperty("cloudId");
        template = instance.getProperty("template");
        this.adapter = adapter;
    }

    @Override
    public int getOrder() {
        return DEFAULT_ORDER;
    }

    @Override
    public String getDescription() {
        return "Destroy virtual machine " + cloudId;
    }

    @Override
    public StepExitCode execute(final ExecutionContext ctx) throws Exception {
        VirtualMachine vm = adapter.getVm(cloudId);
        Task powerOff = vm.powerOffVM_Task();
        Task destroy = vm.destroy_Task();

        wrapped(ctx).safeSet(
                STARTED_TASKS,
                new ArrayList<String>(),
                asList(powerOff.getMOR().getVal(), destroy.getMOR().getVal())
        );

        return StepExitCode.SUCCESS;
    }
}
