package com.xebialabs.deployit.plugin.cloud.vsphere.access;

import java.util.ArrayList;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.google.common.collect.Collections2.filter;
import static com.google.common.collect.Lists.newArrayList;
import static java.util.Arrays.asList;

public class VsphereUtils {

    public static String vmPath(String datacenter, String... path) {
        ArrayList<String> pp = newArrayList(datacenter, "vm");
        if (path != null) {
            pp.addAll(filter(asList(path), new Predicate<String>() {
                @Override
                public boolean apply(String s) {
                    return !isNullOrEmpty(s);
                }
            }));
        }

        return Joiner.on('/').join(pp);
    }

    public static String hostPath(String datacenter, String path) {
        return Joiner.on('/').join(datacenter, "host", path);
    }
}
