containerId = validateNotEmpty(AdminConfig.getid(deployed.container.containmentPath), "Cannot find target container '%s' at containment path '%s'" % (deployed.container.name, deployed.container.containmentPath))

for binding in deployed.bindings:
  names = binding.split(deployed.nameSeparator, 1) 
  if (len(names) == 2):
    values = names[1].split(deployed.valueSeparator, 1)
    if (len(values) == 2):
      args = toAdminConfigArgs({'name': names[0], 'nameInNameSpace': values[0], 'stringToBind': values[1]})

      print "Creating string name space binding %s using args %s" % (deployed.name, args)
      adminConfigCreate('StringNameSpaceBinding', containerId, args)
    else:
      print "ERROR: Invalid string name space binding '%s'. Expected three values 'name%snameInNameSpace%svalue'" % (binding, deployed.nameSeparator, deployed.valueSeparator)
      sys.exit(1)
  else:
    print "ERROR: Invalid string name space binding '%s'. Expected three values 'name%snameInNameSpace%svalue'" % (binding, deployed.nameSeparator, deployed.valueSeparator)
    sys.exit(1)

