dmgrId = AdminConfig.getid(deployed.container.containmentPath)

args = toAdminConfigArgs(deployed.getExposedProperties(True))
print "Creating Core Group for '%s' with args %s" % (dmgrId, args)
coreGroup = adminConfigCreate('CoreGroup', dmgrId, args)

for cluster in deployed.coreGroupClusters:
    if len(cluster.servers) == 0:
        print "Ignoring empty cluster '%s'" % (cluster.name)
    else:
        server = cluster.servers[0]
        currentCoreGroup = AdminTask.getCoreGroupNameForServer("[-nodeName %s -serverName %s]" % (server.nodeName, server.name))
        print "Moving cluster '%s' from Core Group '%s'" % (cluster.name, currentCoreGroup)
        AdminTask.moveClusterToCoreGroup("[-source %s -target %s -clusterName %s]" % (currentCoreGroup, deployed.name, cluster.name))

for server in deployed.coreGroupServers:
    currentCoreGroup = AdminTask.getCoreGroupNameForServer("[-nodeName %s -serverName %s]" % (server.nodeName, server.name))
    print "Moving server '%s' from Core Group '%s'" % (server.name, currentCoreGroup)
    AdminTask.moveServerToCoreGroup("[-source %s -target %s -nodeName %s -serverName %s]" % (currentCoreGroup, deployed.name, server.nodeName, server.name))

if not deployed.preferredCoordinatorServers is None and len(deployed.preferredCoordinatorServers) > 0:
    preferredCoordinatorServerIds = []
    for preferredCoordinatorServer in deployed.preferredCoordinatorServers:
        coreGroupServerContainmentPath = "%s/CoreGroup:%s/CoreGroupServer:%s" % (deployed.container.containmentPath, deployed.name, preferredCoordinatorServer.name)
        coreGroupServerId = validateNotEmpty(AdminConfig.getid(coreGroupServerContainmentPath), "Unable to find Core Group server '%s'" % coreGroupServerContainmentPath)
        preferredCoordinatorServerIds.append(coreGroupServerId)
    print "Assigning preferred coordinator servers '%s'" % (preferredCoordinatorServerIds)
    # for some weird reason, wsadmin only handles changes if the property is set to empty first
    adminConfigModify(coreGroup, [['preferredCoordinatorServers', []]])
    adminConfigModify(coreGroup, [['preferredCoordinatorServers', preferredCoordinatorServerIds]])