package com.xebialabs.deployit.community.wasext.planning;


import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.SingleTypeContributor;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.was.deployed.ExtensibleDeployedResource;

import static com.google.common.collect.Iterables.concat;
import static com.google.common.collect.Iterables.transform;
import static com.xebialabs.deployit.community.wasext.task.DatasourceTasks.testConnection;
import static com.xebialabs.deployit.community.wasext.util.Predicates.extractDeployed;
import static java.lang.Boolean.TRUE;

public class TestDatasourceConnections extends SingleTypeContributor<ExtensibleDeployedResource> {
    private static final Type DATASOURCE_TYPE = Type.valueOf("was.Datasource");
    private static final String DATASOURCE_TEST_CONNECTION_PROPERTY = "testConnection";

    public TestDatasourceConnections() {
        super(DATASOURCE_TYPE);
    }

    @Contributor
    public static void testConnections(Deltas deltas, DeploymentPlanningContext ctx) {
        TestDatasourceConnections contributor = new TestDatasourceConnections();
        contributor.apply(deltas, ctx);
    }

    private void apply(Deltas deltas, DeploymentPlanningContext ctx) {
        filterDeltas(deltas.getDeltas());

        Iterable<Deployed<?, ?>> createdOrModifiedDatasources =
            concat(deployedsCreated, transform(deployedsModified, extractDeployed()));
        for (Deployed<?, ?> datasource : createdOrModifiedDatasources) {
            // may be null
            if (TRUE.equals(datasource.getProperty(DATASOURCE_TEST_CONNECTION_PROPERTY))) {
                testConnection((ExtensibleDeployedResource) datasource, ctx);
            }
        }
    }
}
