containmentPath = '%s/CoreGroup:%s' % (deployed.container.containmentPath, deployed.name)
id = validateNotEmpty(AdminConfig.getid(containmentPath), "Cannot find " + containmentPath)

defaultCoreGroup = AdminTask.getDefaultCoreGroupName()
for cluster in deployed.coreGroupClusters:
    if len(cluster.servers) == 0:
        print "Ignoring empty cluster '%s'" % (cluster.name)
    else:
        print "Returning cluster '%s' to default Core Group '%s'" % (cluster.name, defaultCoreGroup)
        AdminTask.moveClusterToCoreGroup("[-source %s -target %s -clusterName %s]" % (deployed.name, defaultCoreGroup, cluster.name))

for server in deployed.coreGroupServers:
    print "Returning server '%s' to default Core Group '%s'" % (server.name, defaultCoreGroup)
    AdminTask.moveServerToCoreGroup("[-source %s -target %s -nodeName %s -serverName %s]" % (deployed.name, defaultCoreGroup, server.nodeName, server.name))

print "Destroying Core Group %s" % (deployed.name)
AdminConfig.remove(id)