package com.xebialabs.deployit.community.wasext.planning;

import static java.lang.Boolean.TRUE;

import com.xebialabs.deployit.plugin.api.deployment.planning.ContainerContributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.was.container.WasContainer;

abstract class StopAndStartColdDeploymentContainers<C extends WasContainer> extends ContainerContributor<C> {
    private static final String DEPLOY_TO_RUNNING_CONTAINER_PROPERTY = "deployToRunningContainer";

    protected StopAndStartColdDeploymentContainers(Class<C> containerClass) {
        super(containerClass);
    }

    protected void stopAndStartContainers(Deltas deltas, DeploymentPlanningContext ctx) {
        collectContainers(deltas);

        for (C container : containers) {
            // may be null
            if (isColdDeployContainer(container)) {
                // order is configured on the container
                stop(container, ctx);
                start(container, ctx);
            }
        }
    }
    
    public static boolean isColdDeployContainer(WasContainer container) {
        return (container.hasProperty(DEPLOY_TO_RUNNING_CONTAINER_PROPERTY)
                && !TRUE.equals(container.getProperty(DEPLOY_TO_RUNNING_CONTAINER_PROPERTY)));
    }

    protected abstract void stop(C container, DeploymentPlanningContext ctx);
    
    protected abstract void start(C container, DeploymentPlanningContext ctx);
}
