# Create Listener Port
def createListenerPort(containerId, deployed):
    try:
        mls = AdminConfig.list('MessageListenerService', containerId)

        if not mls:
            print "Unable to detect MessageListenerService. MessageListenerService is available on Server and ServerCluster containers."
            sys.exit(1)
        else:
            exposedProperties = deployed.getExposedProperties(True)

            args = toAdminConfigArgs(exposedProperties)

            newListener = adminConfigCreate('ListenerPort', mls, args)
            if deployed.initialStateStarted == True:
                adminConfigCreate('StateManageable', newListener, [['initialState', 'START']])
            else:
                adminConfigCreate('StateManageable', newListener, [['initialState', 'STOP']])
    except Exception, msg:
        print "ListenerPort is available on Server and ServerCluster containers."
        print msg
        sys.exit(1)

lpServers = findListenerPortServerIds(deployed)

[createListenerPort(id,deployed) for id in lpServers]
