/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.community.wasext.planning;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.xebialabs.deployit.community.wasext.container.DynamicCluster;
import com.xebialabs.deployit.community.wasext.planning.StopAndStartColdDeploymentContainers;
import com.xebialabs.deployit.community.wasext.task.ClusterTasks;
import com.xebialabs.deployit.community.wasext.task.DynamicClusterTasks;
import com.xebialabs.deployit.community.wasext.task.ManagedServerTasks;
import com.xebialabs.deployit.community.wasext.util.Predicates;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.SingleTypeContributor;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.was.container.Cluster;
import com.xebialabs.deployit.plugin.was.container.ManagedServer;
import com.xebialabs.deployit.plugin.was.container.WasContainer;
import com.xebialabs.deployit.plugin.was.deployed.ExtensibleDeployedResource;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartReferencedContainers
extends SingleTypeContributor<ExtensibleDeployedResource> {
    private static final String CONTAINER_RESTART_REQUIRED_PROPERTY = "containerRestartRequired";
    private static final Predicate<ConfigurationItem> IS_DYNAMIC_CLUSTER = new Predicate<ConfigurationItem>(){

        public boolean apply(ConfigurationItem configurationItem) {
            return Predicates.instanceOf(Type.valueOf(DynamicCluster.class)).apply((Object)configurationItem);
        }
    };
    private static final Predicate<ConfigurationItem> IS_CLUSTER = new Predicate<ConfigurationItem>(){

        public boolean apply(ConfigurationItem configurationItem) {
            return Predicates.instanceOf(Type.valueOf(Cluster.class)).apply((Object)configurationItem);
        }
    };
    private static final Predicate<ConfigurationItem> IS_MANAGED_SERVER = new Predicate<ConfigurationItem>(){

        public boolean apply(ConfigurationItem configurationItem) {
            return Predicates.instanceOf(Type.valueOf(ManagedServer.class)).apply((Object)configurationItem);
        }
    };
    private static final Logger LOGGER = LoggerFactory.getLogger(RestartReferencedContainers.class);

    public RestartReferencedContainers() {
        super(ExtensibleDeployedResource.class);
    }

    @Contributor
    public void restartContainers(Deltas deltas, DeploymentPlanningContext deploymentPlanningContext) {
        this.filterDeltas(deltas.getDeltas());
        for (WasContainer wasContainer : this.getReferencedContainers()) {
            if (StopAndStartColdDeploymentContainers.isColdDeployContainer(wasContainer)) continue;
            this.restart(wasContainer, deploymentPlanningContext);
        }
    }

    private Set<WasContainer> getReferencedContainers() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Iterable iterable = Iterables.concat((Iterable)this.deployedsCreated, (Iterable)Iterables.transform((Iterable)this.deployedsModified, (Function)Functions.compose(Predicates.cast(ExtensibleDeployedResource.class), Predicates.extractDeployed())), (Iterable)this.deployedsRemoved);
        for (ExtensibleDeployedResource extensibleDeployedResource : iterable) {
            if (!extensibleDeployedResource.hasProperty(CONTAINER_RESTART_REQUIRED_PROPERTY) || !Boolean.TRUE.equals(extensibleDeployedResource.getProperty(CONTAINER_RESTART_REQUIRED_PROPERTY))) continue;
            builder.add((Object)extensibleDeployedResource.getContainer());
        }
        return builder.build();
    }

    protected void restart(WasContainer wasContainer, DeploymentPlanningContext deploymentPlanningContext) {
        if (IS_DYNAMIC_CLUSTER.apply((Object)wasContainer)) {
            DynamicClusterTasks.restart((DynamicCluster)wasContainer, deploymentPlanningContext);
        } else if (IS_CLUSTER.apply((Object)wasContainer)) {
            ClusterTasks.restart((Cluster)wasContainer, deploymentPlanningContext);
        } else if (IS_MANAGED_SERVER.apply((Object)wasContainer)) {
            ManagedServerTasks.restart((ManagedServer)wasContainer, deploymentPlanningContext);
        } else {
            LOGGER.warn("Unable to generate automatic restart steps for unsupported WebSphere container type '{}'", (Object)Type.valueOf(wasContainer.getClass()));
        }
    }
}

