/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.community.wasext.task;

import com.google.common.collect.ImmutableMap;
import com.xebialabs.deployit.community.wasext.step.GlobalWebServerPluginConfigurationCopyStep;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.was.container.Cell;
import java.util.List;
import java.util.Map;

public class CellTasks {
    private static final String UPDATE_GLOBAL_PLUGIN_SCRIPT_PROPERTY = "updateGlobalPluginScript";
    private static final String UPDATE_GLOBAL_PLUGIN_ORDER_PROPERTY = "updateGlobalPluginOrder";
    private static final String PROPAGATE_GLOBAL_PLUGIN_ORDER_PROPERTY = "propagateGlobalPluginOrder";
    private static final String UNMANAGED_WEB_SERVERS_PROPERTY = "unmanagedWebServers";

    public static void updateGlobalPlugin(Cell cell, DeploymentPlanningContext deploymentPlanningContext) {
        deploymentPlanningContext.addStep((Step)new PythonDeploymentStep(((Integer)cell.getProperty(UPDATE_GLOBAL_PLUGIN_ORDER_PROPERTY)).intValue(), (PythonManagingContainer)cell, (String)cell.getProperty(UPDATE_GLOBAL_PLUGIN_SCRIPT_PROPERTY), (Map)ImmutableMap.of((Object)"container", (Object)cell), String.format("Update global Web Server plugin configuration for '%s'", cell.getName())));
    }

    public static void propagateGlobalPlugin(Cell cell, DeploymentPlanningContext deploymentPlanningContext) {
        for (BaseConfigurationItem baseConfigurationItem : (List)cell.getProperty(UNMANAGED_WEB_SERVERS_PROPERTY)) {
            deploymentPlanningContext.addStep((DeploymentStep)new GlobalWebServerPluginConfigurationCopyStep((Integer)cell.getProperty(PROPAGATE_GLOBAL_PLUGIN_ORDER_PROPERTY), cell, baseConfigurationItem));
        }
    }
}

