/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.community.wasext.task;

import com.google.common.collect.ImmutableMap;
import com.xebialabs.deployit.community.wasext.container.DynamicCluster;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicClusterTasks {
    private static final String DEPLOYMENT_MODE_PROPERTY = "deploymentClusterMode";
    private static final String SET_DEPLOYMENT_MODE_SCRIPT_PROPERTY = "setDeploymentModeScript";
    private static final String SET_AUTOMATIC_MODE_SCRIPT_PROPERTY = "setAutomaticModeScript";
    private static final String SET_DEPLOYMENT_MODE_ORDER_PROPERTY = "setDeploymentModeOrder";
    private static final String SET_AUTOMATIC_MODE_ORDER_PROPERTY = "setAutomaticModeOrder";
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicClusterTasks.class);

    public static void setDeploymentMode(DynamicCluster dynamicCluster, DeploymentPlanningContext deploymentPlanningContext) {
        DynamicClusterTasks.setDeploymentMode(dynamicCluster, deploymentPlanningContext, (Integer)dynamicCluster.getProperty(SET_DEPLOYMENT_MODE_ORDER_PROPERTY));
    }

    protected static void setDeploymentMode(DynamicCluster dynamicCluster, DeploymentPlanningContext deploymentPlanningContext, int n) {
        deploymentPlanningContext.addStep((Step)new PythonDeploymentStep(n, (PythonManagingContainer)dynamicCluster.getCell(), (String)dynamicCluster.getProperty(SET_DEPLOYMENT_MODE_SCRIPT_PROPERTY), (Map)ImmutableMap.of((Object)"container", (Object)((Object)dynamicCluster)), String.format("Set dynamic cluster '%s' to %s mode", dynamicCluster.getName(), dynamicCluster.getProperty(DEPLOYMENT_MODE_PROPERTY))));
    }

    public static void setAutomaticMode(DynamicCluster dynamicCluster, DeploymentPlanningContext deploymentPlanningContext) {
        DynamicClusterTasks.setAutomaticMode(dynamicCluster, deploymentPlanningContext, (Integer)dynamicCluster.getProperty(SET_AUTOMATIC_MODE_ORDER_PROPERTY));
    }

    protected static void setAutomaticMode(DynamicCluster dynamicCluster, DeploymentPlanningContext deploymentPlanningContext, int n) {
        deploymentPlanningContext.addStep((Step)new PythonDeploymentStep(n, (PythonManagingContainer)dynamicCluster.getCell(), (String)dynamicCluster.getProperty(SET_AUTOMATIC_MODE_SCRIPT_PROPERTY), (Map)ImmutableMap.of((Object)"container", (Object)((Object)dynamicCluster)), String.format("Set dynamic cluster '%s' to automatic mode", dynamicCluster.getName())));
    }

    public static void restart(DynamicCluster dynamicCluster, DeploymentPlanningContext deploymentPlanningContext) {
        LOGGER.warn("Restarting '{}' containers is currently not supported", (Object)Type.valueOf(DynamicCluster.class));
    }
}

