
def noneOrEmpty(value):
    return (value is None) or (value == '')

def isWebModule(id):
    return id.find('#WebModuleDeployment_') != -1

def toConfigIdList(spaceSeparatedIdList):
    # input format '[id id id ...]'
    # strings.strip(chars) not available in Python 2.1
    return spaceSeparatedIdList.replace('[', '').replace(']', '').split(' ')

def getVersion(wasContainer):
  if hasattr(wasContainer, 'node'):
    return wasContainer.node.cell.version
  if hasattr(wasContainer, 'cell'):
    return wasContainer.cell.version
  else:
    return wasContainer.version

def getApplicationWorkclass(workclassName, deployment):
   workclasses = AdminConfig.list("WorkClass", deployment).splitlines()
   for workclass in workclasses:
       if workclassName == AdminConfig.showAttribute(workclass, "name"):
           return workclass
   return None

installArgs = ['-appname', deployed.name]

# if this is not a WAR deployment, the contextroot property will not be present on the deployed
if hasattr(deployed, 'contextRoot'):
    installArgs.extend(['-contextroot', deployed.contextRoot])

targets = "WebSphere:cell=%s,%s=%s" % (deployed.container.cellName, deployed.container.wasTargetType, deployed.container.name)

# if this is an EJB deployment, the webServers property will not be present on the deployed
if hasattr(deployed, 'webServers'):
    for ws in deployed.webServers:
        targets += "+WebSphere:cell=%s,node=%s,server=%s" % (ws.node.cellName,ws.node.name,ws.name)

servermappings = []
servermappings.append(['.*', '.*', targets])
installArgs.extend(['-MapModulesToServers', servermappings])

vhostmappings = []
if hasattr(deployed, 'virtualHost') and deployed.virtualHost != None:
    vhostmappings.append(['.*', '.*', deployed.virtualHost.name])
else:
    vhostmappings.append(['.*', '.*', 'default_host'])
installArgs.extend(['-MapWebModToVH', vhostmappings])

if len(deployed.sharedLibraries) > 0:
    sharedLibraryMappings = []
    sharedLibNames = ''
    for l in deployed.sharedLibraries:
        sharedLibNames += '+' + l.name
    sharedLibraryMappings.append(['.*', '.*', sharedLibNames])
    installArgs.extend(['-MapSharedLibForMod', sharedLibraryMappings])
    
if hasattr(deployed, 'roleMappings'):
    roleMappings = []
    for role, group in deployed.roleMappings.items():
        # special case - allow specification of 'All Role' without requiring spaces
        if role == 'All':
            role = 'All Role'
        if group == 'Everyone':
            roleMappings.append([role, 'Yes', 'No', '', ''])
        elif group == 'AllAuthenticated':
            roleMappings.append([role, 'No', 'Yes', '', ''])
        elif group == 'AllAuthenticatedInTrustedRealms':
            roleMappings.append([role, 'No', 'No', '', '', 'Yes', '', ''])
        else:
            roleMappings.append([role, 'No', 'No', '', group])
    if hasattr(deployed, 'roleUserMappings'):
        for role, user in deployed.roleUserMappings.items():
            roleMappings.append([role, 'No', 'No', user, ''])
    if len(roleMappings) > 0:
        installArgs.extend(['-MapRolesToUsers', roleMappings])

# if this is an EJB deployment, the preCompileJsps property will not be present on the deployed
if hasattr(deployed, 'preCompileJsps') and deployed.preCompileJsps:
    installArgs.extend(['-preCompileJSPs','-JSPCompileOptions', [['.*', '.*', 'jspcp', 'Yes', 15, 'No']]])

# again, not present for EJB deployments
if hasattr(deployed, 'enableJspClassReloading'):
    if deployed.enableJspClassReloading and not(noneOrEmpty(deployed.jspReloadInterval)):
        installArgs.extend(['-JSPReloadForWebMod', [['.*', '.*', 'Yes', str(deployed.jspReloadInterval)]]])
    else:
        installArgs.extend(['-JSPReloadForWebMod', [['.*', '.*', 'No', '']]])

# optionally, specify a custom directory to store the installed module (if set on the was.Container)
if hasattr(deployed.container, 'moduleDestination') and deployed.container.moduleDestination != None:
    installArgs.extend(['-installed.ear.destination', deployed.container.moduleDestination])

# optionally, specify a custom directory to store the installed module (if set on the was.Module)
if hasattr(deployed, 'moduleDestination') and deployed.moduleDestination != None:
    installArgs.extend(['-installed.ear.destination', deployed.moduleDestination])

if hasattr(deployed, 'additionalInstallFlags'):
    for f in deployed.additionalInstallFlags:
        installArgs.append(f)

print "Deploying application", deployed.name, "with args: %s" % (installArgs)
AdminApp.install(deployed.file, installArgs)

deployment = AdminConfig.getid('/Deployment:%s' % (deployed.name))
deployedObject = AdminConfig.showAttribute(deployment, 'deployedObject')

# if this is not an EAR deployment, the startingWeight property will not be present on the deployed
if hasattr(deployed, 'startingWeight'):
    AdminConfig.modify(deployedObject, [['startingWeight', str(deployed.startingWeight)]])

if hasattr(deployed, 'classloaderMode'):
    if not(noneOrEmpty(deployed.classloaderMode)):
        classLoaderAttr = AdminConfig.showAttribute(deployedObject, 'classloader')
        print "Setting application classloader to %s" % (deployed.classloaderMode)
        AdminConfig.modify(classLoaderAttr, [['mode', deployed.classloaderMode]])

if hasattr(deployed, 'webModuleSessionTimeout'):
    if not(noneOrEmpty(deployed.webModuleSessionTimeout)):
        for module in toConfigIdList(AdminConfig.showAttribute(deployedObject, 'modules')):
            if isWebModule(module):
                AdminConfig.create('WebModuleConfig', module, [['sessionManagement', [['enable', 'true'], ['tuningParams', [['invalidationTimeout', str(deployed.webModuleSessionTimeout)]]]]]])

if hasattr(deployed, 'warClassloaderMode'):
    if not(noneOrEmpty(deployed.warClassloaderMode)):
        for module in toConfigIdList(AdminConfig.showAttribute(deployedObject, 'modules')):
            if isWebModule(module):
                warName = AdminConfig.showAttribute(module, 'uri')
                print "Setting WAR classloader for '%s' to %s" % (warName, deployed.warClassloaderMode)
                AdminConfig.modify(module, [['classloaderMode', deployed.warClassloaderMode]])

if hasattr(deployed, 'jsfImplementation'):
    if not(noneOrEmpty(deployed.jsfImplementation)):
        if getVersion(deployed.container) == 'WAS_61':
            print "WARN: Ignoring property 'jsfImplementation' which is not supported on WAS 6.1"
        else:
            print "Setting JSF implementation to '%s'" % (deployed.jsfImplementation)
            AdminTask.modifyJSFImplementation(deployed.name, "[-implName '%s']" % (deployed.jsfImplementation))

if hasattr(deployed, 'httpTransactionClass'):
    if not(noneOrEmpty(deployed.httpTransactionClass)):
        workclass = validateNotEmpty(getApplicationWorkclass(deployed.defaultHttpWorkclass, deployment), "Cannot find work class '%s' for deployment '%s'" % (deployed.defaultHttpWorkclass, deployment))
        print "Setting default transaction class for '%s' to '%s'" % (deployed.defaultHttpWorkclass, deployed.httpTransactionClass)
        AdminConfig.modify(workclass, [['matchAction', deployed.httpTransactionClass]])
        if hasattr(deployed, 'HttpMatchRule1'):
            if not(noneOrEmpty(deployed.HttpMatchRule1.matchExpression)):
                matchRuleProperties = deployed.HttpMatchRule1.getExposedProperties(True)
                matchRuleProperties['priority'] = 0
                matchRuleArgs = toAdminConfigArgs(matchRuleProperties)
                print "Creating classification rule for '%s': %s" % (deployed.defaultHttpWorkclass, matchRuleArgs)
                AdminConfig.create('MatchRule', workclass, matchRuleArgs)
        if hasattr(deployed, 'HttpMatchRule2'):
            if not(noneOrEmpty(deployed.HttpMatchRule2.matchExpression)):
                matchRuleProperties = deployed.HttpMatchRule2.getExposedProperties(True)
                matchRuleProperties['priority'] = 1
                matchRuleArgs = toAdminConfigArgs(matchRuleProperties)
                print "Creating classification rule for '%s': %s" % (deployed.defaultHttpWorkclass, matchRuleArgs)
                AdminConfig.create('MatchRule', workclass, matchRuleArgs)
        if hasattr(deployed, 'HttpMatchRule3'):
            if not(noneOrEmpty(deployed.HttpMatchRule3.matchExpression)):
                matchRuleProperties = deployed.HttpMatchRule1.getExposedProperties(True)
                matchRuleProperties['priority'] = 2
                matchRuleArgs = toAdminConfigArgs(matchRuleProperties)
                print "Creating classification rule for '%s': %s" % (deployed.defaultHttpWorkclass, matchRuleArgs)
                AdminConfig.create('MatchRule', workclass, matchRuleArgs)

if hasattr(deployed, 'soapTransactionClass'):
    if not(noneOrEmpty(deployed.soapTransactionClass)):
        workclass = validateNotEmpty(getApplicationWorkclass(deployed.defaultSoapWorkclass, deployment), "Cannot find work class '%s' for deployment '%s'" % (deployed.defaultSoapWorkclass, deployment))
        print "Setting default transaction class for '%s' to '%s'" % (deployed.defaultSoapWorkclass, deployed.soapTransactionClass)
        AdminConfig.modify(workclass, [['matchAction', deployed.soapTransactionClass]])
        if hasattr(deployed, 'SoapMatchRule1'):
            if not(noneOrEmpty(deployed.SoapMatchRule1.matchExpression)):
                matchRuleProperties = deployed.SoapMatchRule1.getExposedProperties(True)
                matchRuleProperties['priority'] = 0
                matchRuleArgs = toAdminConfigArgs(matchRuleProperties)
                print "Creating classification rule for '%s': %s" % (deployed.defaultSoapWorkclass, matchRuleArgs)
                AdminConfig.create('MatchRule', workclass, matchRuleArgs)
        if hasattr(deployed, 'SoapMatchRule2'):
            if not(noneOrEmpty(deployed.SoapMatchRule2.matchExpression)):
                matchRuleProperties = deployed.SoapMatchRule2.getExposedProperties(True)
                matchRuleProperties['priority'] = 1
                matchRuleArgs = toAdminConfigArgs(matchRuleProperties)
                print "Creating classification rule for '%s': %s" % (deployed.defaultSoapWorkclass, matchRuleArgs)
                AdminConfig.create('MatchRule', workclass, matchRuleArgs)
        if hasattr(deployed, 'SoapMatchRule3'):
            if not(noneOrEmpty(deployed.SoapMatchRule3.matchExpression)):
                matchRuleProperties = deployed.SoapMatchRule1.getExposedProperties(True)
                matchRuleProperties['priority'] = 2
                matchRuleArgs = toAdminConfigArgs(matchRuleProperties)
                print "Creating classification rule for '%s': %s" % (deployed.defaultSoapWorkclass, matchRuleArgs)
                AdminConfig.create('MatchRule', workclass, matchRuleArgs)

if hasattr(deployed, 'iiopTransactionClass'):
    if not(noneOrEmpty(deployed.iiopTransactionClass)):
        workclass = validateNotEmpty(getApplicationWorkclass(deployed.defaultIiopWorkclass, deployment), "Cannot find work class '%s' for deployment '%s'" % (deployed.defaultIiopWorkclass, deployment))
        print "Setting default transaction class for '%s' to '%s'" % (deployed.defaultIiopWorkclass, deployed.iiopTransactionClass)
        AdminConfig.modify(workclass, [['matchAction', deployed.iiopTransactionClass]])
        if hasattr(deployed, 'IiopMatchRule1'):
            if not(noneOrEmpty(deployed.IiopMatchRule1.matchExpression)):
                matchRuleProperties = deployed.IiopMatchRule1.getExposedProperties(True)
                matchRuleProperties['priority'] = 0
                matchRuleArgs = toAdminConfigArgs(matchRuleProperties)
                print "Creating classification rule for '%s': %s" % (deployed.defaultIiopWorkclass, matchRuleArgs)
                AdminConfig.create('MatchRule', workclass, matchRuleArgs)
        if hasattr(deployed, 'IiopMatchRule2'):
            if not(noneOrEmpty(deployed.IiopMatchRule2.matchExpression)):
                matchRuleProperties = deployed.IiopMatchRule2.getExposedProperties(True)
                matchRuleProperties['priority'] = 1
                matchRuleArgs = toAdminConfigArgs(matchRuleProperties)
                print "Creating classification rule for '%s': %s" % (deployed.defaultIiopWorkclass, matchRuleArgs)
                AdminConfig.create('MatchRule', workclass, matchRuleArgs)
        if hasattr(deployed, 'IiopMatchRule3'):
            if not(noneOrEmpty(deployed.IiopMatchRule3.matchExpression)):
                matchRuleProperties = deployed.IiopMatchRule1.getExposedProperties(True)
                matchRuleProperties['priority'] = 2
                matchRuleArgs = toAdminConfigArgs(matchRuleProperties)
                print "Creating classification rule for '%s': %s" % (deployed.defaultIiopWorkclass, matchRuleArgs)
                AdminConfig.create('MatchRule', workclass, matchRuleArgs)

if hasattr(deployed, 'jmsTransactionClass'):
    if not(noneOrEmpty(deployed.jmsTransactionClass)):
        workclass = validateNotEmpty(getApplicationWorkclass(deployed.defaultJmsWorkclass, deployment), "Cannot find work class '%s' for deployment '%s'" % (deployed.defaultJmsWorkclass, deployment))
        print "Setting default transaction class for '%s' to '%s'" % (deployed.defaultJmsWorkclass, deployed.jmsTransactionClass)
        AdminConfig.modify(workclass, [['matchAction', deployed.jmsTransactionClass]])
        if hasattr(deployed, 'JmsMatchRule1'):
            if not(noneOrEmpty(deployed.JmsMatchRule1.matchExpression)):
                matchRuleProperties = deployed.JmsMatchRule1.getExposedProperties(True)
                matchRuleProperties['priority'] = 0
                matchRuleArgs = toAdminConfigArgs(matchRuleProperties)
                print "Creating classification rule for '%s': %s" % (deployed.defaultJmsWorkclass, matchRuleArgs)
                AdminConfig.create('MatchRule', workclass, matchRuleArgs)
        if hasattr(deployed, 'JmsMatchRule2'):
            if not(noneOrEmpty(deployed.JmsMatchRule2.matchExpression)):
                matchRuleProperties = deployed.JmsMatchRule2.getExposedProperties(True)
                matchRuleProperties['priority'] = 1
                matchRuleArgs = toAdminConfigArgs(matchRuleProperties)
                print "Creating classification rule for '%s': %s" % (deployed.defaultJmsWorkclass, matchRuleArgs)
                AdminConfig.create('MatchRule', workclass, matchRuleArgs)
        if hasattr(deployed, 'JmsMatchRule3'):
            if not(noneOrEmpty(deployed.JmsMatchRule3.matchExpression)):
                matchRuleProperties = deployed.JmsMatchRule1.getExposedProperties(True)
                matchRuleProperties['priority'] = 2
                matchRuleArgs = toAdminConfigArgs(matchRuleProperties)
                print "Creating classification rule for '%s': %s" % (deployed.defaultJmsWorkclass, matchRuleArgs)
                AdminConfig.create('MatchRule', workclass, matchRuleArgs)
