import sys

dynCluster = AdminConfig.getid('/DynamicCluster:%s/' % (container.name))
if dynCluster != "":
	print "WARN: Dynamic cluster '%s' already exists. Doing nothing." % (container.name)
	sys.exit(0)

if container.cell.version == 'WAS_61':
  args = "[-membershipPolicy \"" + container.membershipPolicy + "\" -dynamicClusterProperties \"{{operationalMode manual}"
  if hasattr(container, 'minInstances') and container.minInstances is not None:
    args += "{minInstances " + str(container.minInstances) + "}"
  if hasattr(container, 'maxInstances') and container.maxInstances is not None:
    args += "{maxInstances " + str(container.maxInstances) + "}"
  if hasattr(container, 'numVerticalInstances') and container.numVerticalInstances is not None:
    args += "{numVerticalInstances " + str(container.numVerticalInstances) + "}"
  args += "}\"]"
else:
  args = "[-membershipPolicy \"" + container.membershipPolicy + "\" -dynamicClusterProperties \"[[operationalMode manual]"
  if hasattr(container, 'minInstances') and container.minInstances is not None:
    args += "[minInstances " + str(container.minInstances) + "]"
  if hasattr(container, 'maxInstances') and container.maxInstances is not None:
    args += "[maxInstances " + str(container.maxInstances) + "]"
  if hasattr(container, 'numVerticalInstances') and container.numVerticalInstances is not None:
    args += "[numVerticalInstances " + str(container.numVerticalInstances) + "]"
  args += "]\"]"

print "Creating dynamic cluster '%s' using %s" % (container.name, args)
AdminTask.createDynamicCluster(container.name, args) 
print "Saving configuration"
AdminConfig.save()

# synchronizing all nodes in the cell since the cluster membership is not known
for node in container.cell.nodeAgents:
  nodeName = node.name
  print "Synchronizing '%s'" % (nodeName)
  sync = AdminControl.completeObjectName("type=NodeSync,node=%s,*" % (nodeName));
  if sync == '':
    print >> sys.stderr, "Node '%s' does not exist or is not running" % (nodeName)
    sys.exit(1)
  AdminControl.invoke(sync, 'sync');
  print "Completed synchronization of '%s'" % (nodeName)