import sys
from javax.management import ObjectName
from java.util import Properties

dynCluster = AdminConfig.getid('/DynamicCluster:%s/' % (container.name))
if dynCluster != "":
	print "WARN: Dynamic cluster '%s' already exists. Doing nothing." % (container.name)
	sys.exit(0)

if container.cell.version == 'WAS_61':
  print "ERROR: Dynamic ODR clusters are not supported on WAS 6.1. Doing nothing."
  sys.exit(1)

args = "[-membershipPolicy \"" + container.membershipPolicy + "\"  -dynamicClusterProperties \"[[operationalMode manual]"
if hasattr(container, 'minInstances') and container.minInstances is not None:
  args += "[minInstances " + str(container.minInstances) + "]"
if hasattr(container, 'maxInstances') and container.maxInstances is not None:
  args += "[maxInstances " + str(container.maxInstances) + "]"
if hasattr(container, 'numVerticalInstances') and container.numVerticalInstances is not None:
  args += "[numVerticalInstances " + str(container.numVerticalInstances) + "]"
# closing -dynamicClusterProperties
args += "]\""

if hasattr(container, 'memberTemplateName') and container.memberTemplateName is not None:
  args += "-clusterProperties \"[[templateName " + container.memberTemplateName + "]]\""
# closing args
args += "]"

print "Creating dynamic ODR cluster '%s' using %s" % (container.name, args)
AdminTask.createODRDynamicCluster(container.name, args) 
print "Saving configuration"
AdminConfig.save()
 
# synchronizing all nodes in the cell since the cluster membership is not known
for node in container.cell.nodeAgents:
  nodeName = node.name
  print "Synchronizing '%s'" % (nodeName)
  sync = AdminControl.completeObjectName("type=NodeSync,node=%s,*" % (nodeName));
  if sync == '':
    print >> sys.stderr, "Node '%s' does not exist or is not running" % (nodeName)
    sys.exit(1)
  AdminControl.invoke(sync, 'sync');
  print "Completed synchronization of '%s'" % (nodeName)