# bit nasty...
def getDatastoreType(implementationClassName):
  classname = implementationClassName.lower()
  if implementationClassName.find('derby') != -1:
    return 'was.DerbyDatasource'
  elif implementationClassName.find('microsoftsql') != -1:
    return 'was.MsSqlDatasource'
  elif implementationClassName.find('db2') != -1:
    return 'was.DB2Type2Datasource'
  elif implementationClassName.find('oracle') != -1:
    return 'was.OracleDatasource'
  else:
    return None

def emptyListToEmpty(string):
  if string == '[]':
    return ''
  else:
    return string

def findNonBuiltInProvider(providers):
  for provider in providers.splitlines():
    if provider.find('#builtin_jdbcprovider') == -1:
      return provider
    else:
      return ''

print "Inspecting JDBC Provider '%s'" % (deployed.name)

providerContainmentPath = '%s/JDBCProvider:%s' % (deployed.container.containmentPath, deployed.name)
provider = validateNotEmpty(findNonBuiltInProvider(AdminConfig.getid(providerContainmentPath)), "Cannot find JDBC Provider %s" % (providerContainmentPath))

inspected('name', AdminConfig.showAttribute(provider, 'providerType'))
implementationClassName = AdminConfig.showAttribute(provider, 'implementationClassName')
inspected('implementationClassName', implementationClassName)
inspected('classpath', AdminConfig.showAttribute(provider, 'classpath'))
inspected('nativepath', emptyListToEmpty(AdminConfig.showAttribute(provider, 'nativepath')))

datasources = AdminConfig.getid(providerContainmentPath + '/DataSource:/').split()
if datasources != '':
  datasourceType = getDatastoreType(implementationClassName)
  print "Determined type '%s' for provider '%s'" % (datasourceType, provider)
  if datasourceType is not None:
    for datasource in datasources:
      name = AdminConfig.showAttribute(datasource, 'name')
      print "Discovered data source '%s' of JDBC provider %s" % (name, deployed.name)
      discovered('%s/%s' % (deployed.container.id, name), datasourceType)
  else:
    print "No supported datasource type for implementationClassName '%s'" % (implementationClassName)