def noneOrEmpty(string):
  return string is None or string == ''

jmsProviderContainmentPath = '%s/JMSProvider:%s' % (deployed.container.containmentPath, deployed.jmsProvider)
jmsProviderId = validateNotEmpty(AdminConfig.getid(jmsProviderContainmentPath), "Cannot find WebSphere JMS Provider " + deployed.jmsProvider);
args = toAdminConfigArgs(deployed.getExposedProperties(True))

print "Creating %s for provider %s with args %s " % (deployed.wasType, jmsProviderId, args)
wqqcfId = AdminConfig.create(deployed.wasType, jmsProviderId, args)

# Set container-managed authentication properties
if not noneOrEmpty(deployed.containerAuthDataAlias) or not noneOrEmpty(deployed.mappingConfigAlias):
    mappingArgs = []
    if not noneOrEmpty(deployed.containerAuthDataAlias):
        mappingArgs.append(['authDataAlias', deployed.containerAuthDataAlias])
    if not noneOrEmpty(deployed.mappingConfigAlias):
        mappingArgs.append(['mappingConfigAlias', deployed.mappingConfigAlias])
    else:
        # backwards-compatible behaviour
        print "'mappingConfigAlias' not set. Using 'DefaultPrincipalMapping' as the default value"
        mappingArgs.append(['mappingConfigAlias', 'DefaultPrincipalMapping'])
    print "Creating MappingModule: %s" % (mappingArgs)
    AdminConfig.create('MappingModule', wqqcfId, mappingArgs)

# Set connection pool properties
if hasattr(deployed, 'ConnectionPool'):
    poolArgs = toAdminConfigArgs(deployed.ConnectionPool.getExposedProperties())
    print "Creating ConnectionPool: %s" % (poolArgs)
    AdminConfig.create('ConnectionPool', wqqcfId, poolArgs, 'connectionPool')

# Set session pool properties
if hasattr(deployed, 'SessionPool'):
    poolArgs = toAdminConfigArgs(deployed.SessionPool.getExposedProperties())
    print "Creating SessionPool: %s" % (poolArgs)
    AdminConfig.create('ConnectionPool', wqqcfId, poolArgs, 'sessionPool')


