/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.container;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonInspectionStep;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.was.container.DeploymentManager;
import com.xebialabs.deployit.plugin.was.container.ManagedServer;
import com.xebialabs.deployit.plugin.was.container.Node;
import com.xebialabs.deployit.plugin.was.container.NodeAgent;
import com.xebialabs.deployit.plugin.was.container.WasAppContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Metadata(description="A WebSphere cluster managed by a deployment manager (WAS ND)")
public class Cluster
extends BaseContainer
implements WasAppContainer {
    protected final Map<String, Object> context = ImmutableMap.of((Object)"container", (Object)((Object)this));
    @Property(asContainment=true, label="Deployment manager that manages this this cluster")
    private DeploymentManager cell;
    @Property(required=false, label="Cluster members", description="Servers that are part of this cluster")
    private Set<ManagedServer> servers;

    public DeploymentManager getCell() {
        return this.cell;
    }

    public PythonManagingContainer getManagingContainer() {
        return this.getCell();
    }

    public String getCellName() {
        return this.getCell().getName();
    }

    public Host getHost() {
        return this.cell.getHost();
    }

    public void setCell(DeploymentManager cell) {
        this.cell = cell;
    }

    public void setServers(Set<ManagedServer> servers) {
        this.servers = servers;
    }

    public Set<ManagedServer> getServers() {
        return this.servers;
    }

    public Map<NodeAgent, List<String>> getServerNamesPerNode() {
        HashMap<NodeAgent, List<String>> serverNamesPerNode = new HashMap<NodeAgent, List<String>>();
        if (this.servers != null) {
            for (ManagedServer server : this.servers) {
                NodeAgent node = server.getNode();
                ArrayList<String> serverNames = (ArrayList<String>)serverNamesPerNode.get(node);
                if (serverNames == null) {
                    serverNames = new ArrayList<String>();
                    serverNamesPerNode.put(node, serverNames);
                }
                serverNames.add(server.getName());
            }
        }
        return serverNamesPerNode;
    }

    public Set<Node> getNodes() {
        HashSet<Node> nodes = new HashSet<Node>();
        if (this.servers != null) {
            for (ManagedServer server : this.servers) {
                nodes.add((Node)server.getNode());
            }
        }
        return nodes;
    }

    public String getContainmentPath() {
        return "/ServerCluster:" + this.getName();
    }

    public String getWasConfigIdType() {
        return "ServerCluster";
    }

    public String getWasTargetType() {
        return "cluster";
    }

    public String getShortTypeDescription() {
        return "cluster";
    }

    public List<String> getApplicationManagerObjectNames() {
        Map<NodeAgent, List<String>> serverNamesPerNode = this.getServerNamesPerNode();
        ArrayList<String> applicationManagerObjectNames = new ArrayList<String>();
        for (Map.Entry<NodeAgent, List<String>> each : serverNamesPerNode.entrySet()) {
            NodeAgent eachNode = each.getKey();
            List<String> eachNodeServerNames = each.getValue();
            for (String eachServerName : eachNodeServerNames) {
                applicationManagerObjectNames.add("cell=" + this.cell.getCellName() + ",node=" + eachNode.getName() + ",type=ApplicationManager,process=" + eachServerName + ",*");
            }
        }
        return applicationManagerObjectNames;
    }

    @Inspect
    public void inspect(InspectionContext ctx) {
        HashMap pythonVars = Maps.newHashMap();
        pythonVars.put("container", this);
        ctx.addStep((Step)new PythonInspectionStep((ConfigurationItem)this, this.getManagingContainer(), "was/container/inspect-cluster.py", (Map)pythonVars, "Inspect " + (Object)((Object)this)));
    }

    public List<Step> controlTaskDispatch(String name) {
        PropertyDescriptor scriptProperty = DescriptorRegistry.getDescriptor((Type)this.getType()).getPropertyDescriptor(name + "PythonScript");
        Preconditions.checkArgument((scriptProperty != null ? 1 : 0) != 0, (String)"Control task script property '%sPythonScript' not defined for CI type %s", (Object[])new Object[]{name, this.getType()});
        return ImmutableList.of((Object)new PythonDeploymentStep(1, this.getManagingContainer(), (String)scriptProperty.get((ConfigurationItem)this) + ".py", this.context, "Executing " + name));
    }
}

