package com.xebialabs.deployit.community.wasext.planning;


import com.google.common.base.Function;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.was.container.Cell;
import com.xebialabs.deployit.plugin.was.container.ManagedWebServer;

import java.util.Set;

import static com.google.common.collect.Iterables.transform;
import static com.xebialabs.deployit.community.wasext.task.CellTasks.propagateGlobalPlugin;
import static com.xebialabs.deployit.community.wasext.task.CellTasks.updateGlobalPlugin;
import static com.xebialabs.deployit.community.wasext.task.ManagedWebServerTasks.generatePlugin;
import static com.xebialabs.deployit.community.wasext.task.ManagedWebServerTasks.propagatePlugin;
import static java.lang.Boolean.TRUE;

public class GenerateAndPropagateGlobalWebServerPlugin extends ReferencedCellContributor {
    private static final String CELL_UPDATE_GLOBAL_PLUGIN_PROPERTY = "updateGlobalPlugin";

    @Contributor
    public void generateAndPropagateWebserverPlugin(Deltas deltas, DeploymentPlanningContext ctx) {
        filterDeltas(deltas.getDeltas());

        for (Cell cell : getReferencedCells()) {
            // may be null
            if (TRUE.equals(cell.getProperty(CELL_UPDATE_GLOBAL_PLUGIN_PROPERTY))) {
                updateGlobalPlugin(cell, ctx);
                propagateGlobalPlugin(cell, ctx);
            }
        }
    }

}
