/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.community.wasext.step;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.community.wasext.util.Closeables;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.was.container.ManagedWebServer;
import com.xebialabs.deployit.plugin.was.container.Node;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.util.OverthereFileCopier;
import java.io.Closeable;

public class ManagedWebServerPluginConfigurationCopyStep
implements DeploymentStep {
    private final int order;
    private final String description;
    private final Host srcHost;
    private final Host targetHost;
    private final String pluginSrcFilePath;
    private final String pluginDestFilePath;

    public ManagedWebServerPluginConfigurationCopyStep(int order, ManagedWebServer webserver) {
        this.order = order;
        Node webserverNode = webserver.getNode();
        this.srcHost = webserverNode.getCell().getCellHost();
        this.targetHost = (Host)webserver.getProperty("host");
        this.pluginSrcFilePath = String.format("%s/config/cells/%s/nodes/%s/servers/%s/plugin-cfg.xml", webserverNode.getCell().getWasHome(), webserverNode.getCellName(), webserverNode.getNodeName(), webserver.getName().trim());
        this.pluginDestFilePath = (String)Preconditions.checkNotNull((Object)webserver.getProperty("pluginConfigurationPath"), (Object)"pluginConfigurationPath");
        this.description = String.format("Copy WebSphere plugin configuration file directly to '%s' for unmanaged webserver '%s'", this.targetHost.getName(), webserver.getName());
    }

    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Step.Result execute(DeploymentExecutionContext ctx) throws Exception {
        OverthereConnection srcHostConnection = this.srcHost.getConnection();
        OverthereConnection targetHostConnection = this.targetHost.getConnection();
        try {
            OverthereFile source = srcHostConnection.getFile(this.pluginSrcFilePath);
            OverthereFile remote = targetHostConnection.getFile(this.pluginDestFilePath);
            ctx.logOutput(String.format("Copying generated plugin configuration file from '%s' on '%s' to '%s' on '%s'", this.pluginSrcFilePath, this.srcHost, this.pluginDestFilePath, this.targetHost));
            OverthereFileCopier.copy((OverthereFile)source, (OverthereFile)remote);
        }
        finally {
            Closeables.closeQuietly((Closeable)srcHostConnection);
            Closeables.closeQuietly((Closeable)targetHostConnection);
        }
        return Step.Result.Success;
    }

    public int getOrder() {
        return this.order;
    }
}

