import time

def startApplicationOnServer(appName, cellName, serverName, serverNodeName):
    appMgrName = "cell=%s,node=%s,type=ApplicationManager,process=%s,*" % (cellName, serverNodeName, serverName)
    appMgr = AdminControl.queryNames(appMgrName)
    if appMgr == '':
        print "Cannot (completely) start", appName,"because the server", serverName, "has not been started."
        return False
    else:
        print "Starting application", appName, "on", serverName
        AdminControl.invoke(appMgr, 'startApplication', '["' + appName + '"]')
        print "Done."
    return True

# Wait for application to be installed
while True :
    if AdminApp.isAppReady(deployed.name) == 'true':
        break;
    print "\nWaiting for", deployed.name, "deployment to finish."
    time.sleep(10)

if (deployed.container.wasTargetType == "cluster"):
    # always use ServerCluster rather than the actual containment path to get the members - they are not listed for DynamicClusters, for instance
    clusterId = AdminConfig.getid("/ServerCluster:%s" % (deployed.container.name))
    membersProperty = AdminConfig.showAttribute(clusterId, 'members')
    members = membersProperty[1:-1].split()
    numServersWithRunningApplication = 0
    for member in members:
        serverName = AdminConfig.showAttribute(member, 'memberName')
        serverNodeName = AdminConfig.showAttribute(member, 'nodeName')
        if isApplicationRunningOnServer(deployed.name, serverName, serverNodeName):
            print "Application", deployed.name, "on", serverName, "already started."
            numServersWithRunningApplication += 1
        elif startApplicationOnServer(deployed.name, deployed.container.cellName, serverName, serverNodeName):
            numServersWithRunningApplication += 1
    if numServersWithRunningApplication < len(members):
        if deployed.container.failOnPartialApplicationStart:
            raise Exception("Application %s only partially started (running on %s of %s cluster members)" % (deployed.name, numServersWithRunningApplication, len(members)))
        else:
            print "WARN: Application", deployed.name, "only partially started (running on", str(numServersWithRunningApplication), "of", str(len(members)), "cluster members)"
else:
    if isApplicationRunningOnServer(deployed.name, deployed.container.name, deployed.container.nodeName):
        print "Application", deployed.name, "on", deployed.container.name, "already started."
    elif not startApplicationOnServer(deployed.name, deployed.container.cellName, deployed.container.name, deployed.container.nodeName):
        raise Exception("Unable to start application")