/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.contributor;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.was.util.Predicates;
import java.util.List;

public abstract class CollectDeployedsOfTypesContributor<D extends Deployed<?, ?>> {
    protected final List<Type> typesOfInterest;
    protected List<D> deployedsCreated = Lists.newArrayList();
    protected List<TypedDelta> deployedsModified = Lists.newArrayList();
    protected List<TypedDelta> deployedsNoop = Lists.newArrayList();
    protected List<D> deployedsRemoved = Lists.newArrayList();

    protected CollectDeployedsOfTypesContributor(Type typeOfDeployed) {
        this.typesOfInterest = Lists.newArrayList((Object[])new Type[]{typeOfDeployed});
    }

    protected CollectDeployedsOfTypesContributor(List<Type> typeOfDeployed) {
        this.typesOfInterest = typeOfDeployed;
    }

    protected Predicate<Delta> isOfType() {
        if (this.typesOfInterest.size() == 1) {
            return Predicates.deltaOf(this.typesOfInterest.get(0));
        }
        return com.google.common.base.Predicates.or((Iterable)Iterables.transform(this.typesOfInterest, (Function)new Function<Type, Predicate<Delta>>(){

            public Predicate<Delta> apply(Type input) {
                return Predicates.deltaOf(input);
            }
        }));
    }

    protected void filterDeltas(List<Delta> deltas) {
        Predicate<Delta> isOfType = this.isOfType();
        for (Delta d : deltas) {
            if (!isOfType.apply((Object)d)) continue;
            switch (d.getOperation()) {
                case CREATE: {
                    this.deployedsCreated.add(d.getDeployed());
                    break;
                }
                case MODIFY: {
                    this.deployedsModified.add(new TypedDelta(d));
                    break;
                }
                case NOOP: {
                    this.deployedsNoop.add(new TypedDelta(d));
                    break;
                }
                case DESTROY: {
                    this.deployedsRemoved.add(d.getPrevious());
                }
            }
        }
    }

    protected class TypedDelta
    implements Delta {
        private final Delta delegate;

        private TypedDelta(Delta delegate) {
            this.delegate = delegate;
        }

        public Operation getOperation() {
            return this.delegate.getOperation();
        }

        public D getPrevious() {
            return this.delegate.getPrevious();
        }

        public D getDeployed() {
            return this.delegate.getDeployed();
        }

        public List<String> getIntermediateCheckpoints() {
            return this.delegate.getIntermediateCheckpoints();
        }
    }
}

