#
def listWorkManagersInContainer(container, prototype):
    return wsadminToList(AdminConfig.getid('%s/WorkManagerProvider:/%s:/' % (container.containmentPath, prototype.wasType)))

def inspectWorkManager(deployedId, deployedName, resourceId, prototype):
    inspectDeployedProperties(deployedId, deployedName, resourceId, prototype, ["name", "workReqQFullAction"])
    inspectServiceNamesProperties(deployedId, resourceId, "ServiceNames_", "serviceNames")
    inspectedProperty(deployedId, "workReqQFullAction", valuesToWorkReqQFullActionMap[AdminConfig.showAttribute(resourceId, "workReqQFullAction")])
    providerId = AdminConfig.showAttribute(resourceId, "provider")
    inspectedProperty(deployedId, "provider", AdminConfig.showAttribute(providerId, "name"))
    inspectNestedJ2EEResourceProperties(deployedId, resourceId, "propertySet", "customProperties")

discoverAndInspectResources(container, prototype, listWorkManagersInContainer, inspectWorkManager)