customPerformanceSettingList = ['maxBufferedDependencyIds', 'maxBufferedCacheIdsPerMetaEntry', 'maxBufferedTemplates']
cacheThresholdList = ['algorithm', 'highThreshold', 'lowThreshold']
diskCacheSettingsList = ['diskCacheCleanupFrequency', 'diskCachePerformanceLevel', 'diskCacheEntrySizeInMB', 'diskCacheSizeInEntries', 'diskCacheSizeInGB', 'flushToDiskOnStop', 'diskOffloadLocation']

def inspectNestedCacheSettings(deployedId, servletCacheInstance, nestedProperty, deployitString):
    nestedPropId = AdminConfig.showAttribute(servletCacheInstance, nestedProperty)
    properties = wsadminToDict(AdminConfig.show(nestedPropId))
    for property in customPerformanceSettingList:
        if property in properties.keys():
            inspectedProperty(deployedId, property, AdminConfig.showAttribute(nestedPropId, property))
    for property in cacheThresholdList:
        if property in properties.keys():
            inspectedProperty(deployedId, '%s%s' % (deployitString, property), AdminConfig.showAttribute(nestedPropId, property))

def inspectDiskCacheSettings(deployedId, servletCacheInstance):
    for property in diskCacheSettingsList:
        inspectedProperty(deployedId, property, AdminConfig.showAttribute(servletCacheInstance, property))

def discoverAndInspectServletCacheInstance(container):
    cacheProviderContainmentPath = '%s/CacheProvider:/' % (container.containmentPath)
    try:
        cacheProviders = validateNotEmpty(wsadminToList(AdminConfig.getid(cacheProviderContainmentPath)), "Cannot locate CacheProvider ContainmentPath '%s'" % (cacheProviderContainmentPath))

        for providerId in cacheProviders:
            servletCacheInstanceList = wsadminToList(AdminConfig.list('ServletCacheInstance', providerId))
            for servletCacheInstance in servletCacheInstanceList:
                deployedName = AdminConfig.showAttribute(servletCacheInstance, 'name')
                deployedId = container.id + '/' + deployedName
                discovered(deployedId, prototype.type)
                inspectDeployedProperties(deployedId, deployedName, servletCacheInstance, prototype)
                inspectDiskCacheSettings(deployedId, servletCacheInstance)
                inspectNestedCacheSettings(deployedId, servletCacheInstance, 'diskCacheCustomPerformanceSettings', 'None')
                inspectNestedCacheSettings(deployedId, servletCacheInstance, 'diskCacheEvictionPolicy', 'DiskCache_')
                if getVersion(container) != 'WAS_61':
                    inspectedProperty(deployedId, 'memoryCacheSizeInMB', AdminConfig.showAttribute(servletCacheInstance, 'memoryCacheSizeInMB'))
                    inspectNestedCacheSettings(deployedId, servletCacheInstance, 'memoryCacheEvictionPolicy', 'MemoryCache_')
                inspectNestedJ2EEResourceProperties(deployedId, servletCacheInstance, "propertySet", "customProperties")
                inspectedItem(deployedId)
    except:
        print "Unable to discover ServletCacheInstance on container:%s", container.containmentPath

for c in findAllContainers(container):
    discoverAndInspectServletCacheInstance(c)
