import sys

def createServer(nodeName, serverName, serverType):
    args = ['-name', serverName]
    args = listToAdminTaskArgs(args)
    print "Creating server '%s' on node '%s': %s" % (serverName, nodeName, args)
    if serverType == 'APPLICATION_SERVER':
        AdminTask.createApplicationServer(nodeName, args)
    elif serverType == 'PROXY_SERVER':
        AdminTask.createProxyServer(nodeName, args)

def checkIfServerExists(nodeName, serverName):
    server = AdminConfig.getid('/Node:%s/Server:%s/' % (nodeName, serverName))
    if server != "":
        print "WARN: Server '%s' already exists on node '%s'. Doing nothing." % (serverName, nodeName)
        sys.exit(0)

nodeName = deployed.container.nodeName
serverName = deployed.name

# ilx: do not create server if it should be part of a cluster?
checkIfServerExists(nodeName, serverName)
createServer(nodeName, serverName, deployed.serverType)


saveConfiguration()
syncNode(nodeName)

