#
def getMessageStoreArgs(deployed):
    args = []

    if not deployed.DataStore.enabled and not deployed.FileStore.enabled:
        printErrorAndExit("ERROR: Please specify to use either the Data Store or the File Store as the message store.")

    if deployed.DataStore.enabled:
        args.append("-dataStore")
        props = deployed.DataStore.getExposedProperties(True)
        if getVersion(deployed.container) in ["WAS_61", "WAS_70", "WAS_80"]:
            del props["restrictLongDBLock"]

    if deployed.FileStore.enabled:
        args.append("-fileStore")
        props = deployed.FileStore.getExposedProperties(True)
        if deployed.FileStore.unlimitedPermanentStoreSize:
            del props["maxPermanentStoreSize"]
        if deployed.FileStore.unlimitedTemporaryStoreSize:
            del props["maxTemporaryStoreSize"]

    del props["enabled"]
    args.extend(toAdminTaskArgs(props))
    return args

def sibusMemberArgs(deployed):
    props = deployed.getExposedProperties(True)
    args = toAdminTaskArgs(props)

    if deployed.node and deployed.server:
        args.extend(getMessageStoreArgs(deployed))
    elif deployed.cluster:
        args.extend(getMessageStoreArgs(deployed))
        if getVersion(deployed.container) != "WAS_61":
            clusterProps = deployed.Cluster.getExposedProperties(True)
            if deployed.Cluster.policyName != "CUSTOM":
                for key in ["failover", "failback", "preferredServersOnly", "preferredServerList"]:
                    del clusterProps[key]
            else:
                del clusterProps["preferredServerList"]
                if deployed.Cluster.preferredServerList:
                    preferredServerList = []
                    for key, value in deployed.Cluster.preferredServerList.items():
                        preferredServerList.append([key, value])
                    args.extend(["-preferredServerList", preferredServerList])
            args.extend(toAdminTaskArgs(clusterProps))
    elif deployed.wmqServer:
        args.extend(toAdminTaskArgs(deployed.Wmq.getExposedProperties(True)))

    return args

args = sibusMemberArgs(deployed)
print "Creating SIBusMember '%s' in SIBus '%s' with args '%s'" % (deployed.name, deployed.bus, args)
AdminTask.addSIBusMember(args)