#
def projectDict(props, mappings):
    for oldKey in props.keys():
        newKey = mappings.get(oldKey)
        if newKey is not None:
            if newKey != "":
                props[newKey] = props[oldKey]
            del props[oldKey]
    return props

def inspectProperties(deployedId, resourceId, propertyPrefix="", mappings={}):
    props = wsadminToDict(AdminConfig.show(resourceId))
    props = projectDict(props, mappings)
    if propertyPrefix:
        propertyNames = getattr(prototype, propertyPrefix[:-1]).getExposedPropertyNames()
    else:
        propertyNames = prototype.getExposedPropertyNames()
    for propertyName in propertyNames:
        propertyValue = props.get(propertyName)
        if propertyValue:
            inspectedProperty(deployedId, propertyPrefix + propertyName, propertyValue)

def getMemberName(busName, memberId):
    server = AdminConfig.showAttribute(memberId, "server")
    node = AdminConfig.showAttribute(memberId, "node")
    cluster = AdminConfig.showAttribute(memberId, "cluster")
    mqServer = AdminConfig.showAttribute(memberId, "mqServer")

    if server:
        memberName = "%s_%s_%s" % (busName, node, server)
    elif cluster:
        memberName = "%s_%s" % (busName, cluster)
    else:
        memberName = "%s_%s" % (busName, mqServer)
    return memberName

########################################################################################################################

serverEngineIds = wsadminToList(AdminConfig.list("SIBMessagingEngine"))
mqEngineIds = wsadminToList(AdminConfig.list("SIBMQServerBusMember"))
for busId in wsadminToList(AdminConfig.list("SIBus")):
    busName = AdminConfig.showAttribute(busId, 'name')
    for memberId in wsadminToList(AdminConfig.showAttribute(busId, "busMembers")):
        memberName = getMemberName(busName, memberId)
        deployedId = container.id + "/" + memberName
        discovered(deployedId, prototype.type)

        # inspect SIBusMember properties
        inspectedProperty(deployedId, "bus", busName)
        inspectProperties(deployedId, memberId, "", {'mqServer': 'wmqServer'})
        inspectProperties(deployedId, memberId, "Cluster_", {'assistanceEnabled': 'enableAssistance'})

        # inspect SIBusEngine properties
        for targetId in wsadminToList(AdminConfig.showAttribute(memberId, "target")):
            engineUuid = AdminConfig.showAttribute(targetId, "engineUuid")
            matchedServerEngineIds = [engineId for engineId in serverEngineIds if AdminConfig.showAttribute(engineId, "uuid") == engineUuid]
            matchedMQEngineIds = [engineId for engineId in mqEngineIds if AdminConfig.showAttribute(engineId, "uuid") == engineUuid]

            if len(matchedServerEngineIds) > 0:
                engineId = matchedServerEngineIds[0]
                if AdminConfig.showAttribute(engineId, "messageStoreType") == "DATASTORE":
                    inspectProperties(deployedId, AdminConfig.showAttribute(engineId, "dataStore"), "DataStore_", {'dataSourceName': 'datasourceJndiName'})
                    inspectedProperty(deployedId, "DataStore_enabled", "True")
                    inspectedProperty(deployedId, "FileStore_enabled", "False")
                else:
                    inspectProperties(deployedId, AdminConfig.showAttribute(engineId, "fileStore"), "FileStore_")
                    inspectedProperty(deployedId, "FileStore_enabled", "True")
                    inspectedProperty(deployedId, "DataStore_enabled", "False")
            elif len(matchedMQEngineIds) > 0:
                inspectProperties(deployedId, matchedMQEngineIds[0], "Wmq_", {'messagingAuthAlias': 'securityAuthAlias', 'transportChainName': 'transportChain', 'trustMessageUserIdentifiers': 'trustUserIds'})
            else:
                printErrorAndExit("Cannot find SIB engine for member '%s' and name '%s'" % (memberName, engineName))

        inspectedItem(deployedId)
