def wmqConnectionFactoryProps(deployed):
    exposedProperties = deployed.getExposedProperties(True)

    if deployed.transportType == 'BINDINGS_THEN_CLIENT':
        if deployed.connameList:
            host =  deployed.connameList.rsplit(',')[0].split('(')[0]
            try:
                port = int(deployed.connameList.rsplit(',')[0].split('(')[1][:-1])
            except IndexError:
                exposedProperties['port'] = deployed.port
            else:
                exposedProperties['port'] = port
            exposedProperties['host'] = host
        else:
            pass

    if getVersion(deployed.container) == 'WAS_61':
        if deployed.transportType == 'BINDINGS_THEN_CLIENT':
            print "BINDINGS_THEN_CLIENT default mapped to BINDINGS on WAS 6.1"
            exposedProperties['transportType'] = 'BINDINGS'

    if not exposedProperties.get('sslConfiguration'):
        exposedProperties['sslConfiguration'] = exposedProperties['sslConfigurationName']
        del exposedProperties['sslConfigurationName']

    if exposedProperties.get("ccdtUrl", None):
        exclude_props = ["host", "port", "channel", "localAddress", "connameList"]
        exposedProperties['transportType'] = 'CLIENT'
        print "Ignoring properties not valid in combination with 'ccdtUrl' - %s" % exclude_props
        for exclude_prop in exclude_props:
            del exposedProperties[exclude_prop]

    return exposedProperties

def inspectWmqConnectionFactories(deployedId, jmsName, jmsId, container, prototype):
    inspectJmsQueueConnectionFactories(deployedId, jmsName, jmsId, container, prototype)

    if 'sslConfiguration' in getConfigTypeAttrs(prototype.wasType):
        inspectedProperty(deployedId, 'sslConfigurationName', AdminConfig.showAttribute(jmsId, 'sslConfiguration'))
