package com.xebialabs.deployit.plugin.was.deployed;

import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployable;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployedContainer;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseEmbeddedDeployed;

@SuppressWarnings("serial")
@Metadata(virtual = true, description = "Base class for all embedded deployed configuration items.")
public class ExtensibleEmbeddedDeployed<D extends EmbeddedDeployable, C extends EmbeddedDeployedContainer> extends BaseEmbeddedDeployed<D, C> {

    @Property(hidden = false, required = false, description = "The name used by Websphere")
    private String wasName;

    @Override
    public String getName() {
        if(wasName != null && !wasName.equals("")){
            return wasName;
        } else {
            return super.getName();
        }
    }

    public String getWasName() {
        return wasName;
    }

    public void setWasName(String wasName) {
        this.wasName = wasName;
    }
}
