#
print "Inspecting cell %s" % (container.name)

def inspectPropertiesOnWasObject(wasType, objectId, wasObject, properties):
    properties = excludeUnsupportedProperties(wasType, properties)
    props = wsadminToDict(AdminConfig.show(wasObject))
    for propertyName in properties.keys():
        propertyValue = props[propertyName]
        inspectedProperty(objectId, propertyName, propertyValue)


def clusterInspectCallback(clusterId, cluster):
    clusterProperties = {'serverType': ''}
    inspectPropertiesOnWasObject('ServerCluster', clusterId, cluster, clusterProperties)


def appserverInspectCallback(serverId, server):
    serverProperties = {'serverType': ''}
    inspectPropertiesOnWasObject('Server', serverId, server, serverProperties)


def getWebserverPort(webserverName):
    NamedEndPoints = AdminConfig.list("NamedEndPoint", webserverName).split(lineSeparator)
    for namedEndPoint in NamedEndPoints:
        endPointName = AdminConfig.showAttribute(namedEndPoint, "endPointName")

        if endPointName == 'WEBSERVER_ADDRESS':
            endPoint = AdminConfig.showAttribute(namedEndPoint, "endPoint")
            port = AdminConfig.showAttribute(endPoint, "port")
            return port
    return None


def webserverInspectCallback(webserverId, webserver):
    servers = AdminConfig.list('ServerEntry').splitlines()
    WebServerName = webserver.split('(', 1)[0]
    configPath = ''
    installPath = ''
    for server in servers:
        ServerName = server.split('(', 1)[0]
        if WebServerName == ServerName:
            serverInfo = AdminConfig.showall(webserver)
            for info in serverInfo.split('\n'):
                infoList = wsadminToList(info)
                if infoList[0] == 'webserverInstallRoot':
                    installPath = infoList[1]
                    if installPath[len(installPath)-1] != '/':
                        configPath = installPath + "/conf/httpd.conf"
                    else:
                        configPath = installPath + "conf/httpd.conf"

            properties = {'port': '', 'installPath':'', 'configPath':''}
            props = {'port': getWebserverPort(server), 'installPath': installPath, 'configPath': configPath}

            for propertyName in properties.keys():
                propertyValue = props[propertyName]
                inspectedProperty(webserverId, propertyName, propertyValue)

# Inspect cell name
appendTypeToName=container.appendTypeToName
inspectCellName(container)
if isNetworkDeploymentEdition(container):
    discoverAndInspectNetworkDeploymentEditionContainers(container, appserverInspectCallback=appserverInspectCallback,
                                                         clusterInspectCallback=clusterInspectCallback,
                                                         webserverInspectCallback=webserverInspectCallback, appendTypeToName=appendTypeToName)
else:
    discoverAndInspectBaseEditionContainers(container)
