/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.container;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.api.validation.Range;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.python.ControlTaskDelegate;
import com.xebialabs.deployit.plugin.python.DerivedProperty;
import com.xebialabs.deployit.plugin.python.PythonManagedContainer;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.was.container.DeploymentManager;
import com.xebialabs.deployit.plugin.was.container.HealthPolicyMembershipContainer;
import com.xebialabs.deployit.plugin.was.container.Node;
import com.xebialabs.deployit.plugin.was.util.OperationalMode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Metadata(description="A WebSphere dynamic ODR cluster managed by a WebSphere deployment manager (WAS ND)")
public class DynamicOdrCluster
extends BaseContainer
implements HealthPolicyMembershipContainer,
PythonManagedContainer {
    @Property(asContainment=true, label="Deployment manager that manages this node agent")
    private DeploymentManager cell;
    @Property(label="Membership Policy", defaultValue="node_nodegroup = 'DefaultNodeGroup'", description="Specify an expression that is used to define which nodes are used for the dynamic ODR cluster.Ex:node_nodegroup = 'my_node_group'")
    private String membershipPolicy;
    @Property(required=false, label="NodeGroup Name", defaultValue="DefaultNodeGroup", description="The node group in which to create cluster members. Required for WAS_85")
    private String nodeGroupName;
    @Property(required=true, label="Minimum number of cluster instances", defaultValue="1", description="Choose the minimum number of instances to have running when the dynamic ODR cluster is activated.")
    @Range(minimum=0, message="The minimum number of instances must be a positive value")
    private int minInstances;
    @Property(required=true, label="Maximum number of cluster instances", defaultValue="-1", description="Choose the Maximum number of instances to have running when the dynamic ODR cluster is activated.")
    @Range(minimum=-1, message="The maximum number of instances must be greater than or equal to zero")
    private int maxInstances;
    @Property(required=true, label="Vertical stacking of instances on node", defaultValue="0", description="If the nodes in the dynamic ODR cluster have extra capacity, vertical stacking allows an application to make more effective use of the capacity by starting multiple instances on the same node.")
    @Range(minimum=0, message="The vertical stacking number of instances must be a positive value.")
    private int numVerticalInstances;
    @Property(required=false, defaultValue="MANUAL", description="Specifies the level that the dynamic cluster interacts with the dynamic operations environment.")
    private OperationalMode operationalMode;
    @Property(required=false, label="MemberTemplate Name", description="Select a server template on which to model the servers for the new dynamic cluster,Uses the system default if not set")
    private String memberTemplateName;
    @Property(required=false, defaultValue="was/container/create-dynamic-odr-cluster.py", hidden=true)
    private String createPythonScript;
    @Property(required=false, defaultValue="was/container/modify-dynamic-cluster.py", hidden=true)
    private String modifyPythonScript;
    @Property(required=false, defaultValue="was/container/destroy-dynamic-cluster.py", hidden=true)
    private String destroyPythonScript;

    @Override
    public DeploymentManager getCell() {
        return this.cell;
    }

    public void setCell(DeploymentManager cell) {
        this.cell = cell;
    }

    public PythonManagingContainer getManagingContainer() {
        return this.getCell();
    }

    @Override
    @DerivedProperty(value="cellName")
    public String getCellName() {
        return this.getCell().getCellName();
    }

    @ControlTask(label="Create", description="This control task is used to create a new DynamicOdrCluster")
    public List<Step> create() {
        return this.invokeControlTask("create");
    }

    @ControlTask(label="Modify", description="This control task is used to modify the properties of an existing DynamicOdrCluster")
    public List<Step> modify() {
        return this.invokeControlTask("modify");
    }

    @ControlTask(label="Destroy", description="This control task is used to destroy an existing DynamicOdrCluster")
    public List<Step> destroy() {
        return this.invokeControlTask("destroy");
    }

    private List<Step> invokeControlTask(String name) {
        HashMap args = Maps.newHashMap();
        return ControlTaskDelegate.dispatch((String)name, (Map)args, (ConfigurationItem)this, (Container)this);
    }

    @Override
    public String getContainmentPath() {
        return "/ServerCluster:" + this.getName();
    }

    @Override
    public String getWasConfigIdType() {
        return "DynamicCluster";
    }

    @Override
    public String getWasTargetType() {
        return "cluster";
    }

    @Override
    public String getShortTypeDescription() {
        return "cluster";
    }

    public Host getHost() {
        return this.getCell().getHost();
    }

    public Set<Node> getNodes() {
        HashSet<Node> nodes = new HashSet<Node>();
        return nodes;
    }
}

