
def discoverAndInspectJdbcProvider(container, canHandleProviderTypeCallback):
    providerContainmentPath = '%s/JDBCProvider:/' % (container.containmentPath)
    providers = AdminConfig.getid(providerContainmentPath)
    ignoredProps = ['name']
    if getVersion(container) == 'WAS_61': 
        ignoredProps.append('isolatedClassLoader')
    for JdbcProvider in wsadminToList(providers):
        providerType = AdminConfig.showAttribute(JdbcProvider, 'providerType')
        if canHandleProviderTypeCallback(JdbcProvider, providerType):
            deployedName = AdminConfig.showAttribute(JdbcProvider, 'name')
            if appendTypeToName:
                deployedId = container.id + '/' + deployedName + '_' + prototype.type
            else:
                deployedId = container.id + '/' + deployedName
            discovered(deployedId, prototype.type)
            inspectedProperty(deployedId, 'wasName', deployedName)
            inspectDeployedProperties(deployedId, deployedName, JdbcProvider, prototype, ignoredProps)
            inspectedItem(deployedId)

def discoverAndInspectJdbcProviders(canHandleProviderTypeCallback):
    for c in findAllContainers(container):
        discoverAndInspectJdbcProvider(c, canHandleProviderTypeCallback)
