#
def reverseMap(map):
    reverse = {}
    for k, v in map.items():
        reverse[v] = k
    return reverse

serviceNamesToValuesMap = {
    "security":                     "security",
    "applicationProfilingService":  "AppProfileService",
    "workArea":                     "UserWorkArea",
    "internationalization":         "com.ibm.ws.i18n",
    "serviceClass":                 "zos.wlm"
}
valuesToServiceNamesMap = reverseMap(serviceNamesToValuesMap)

workReqQFullActionToValuesMap = {
    "Block":    "0",
    "Fail":     "1"
}
valuesToWorkReqQFullActionMap = reverseMap(workReqQFullActionToValuesMap)

def getServiceNames(deployed):
    serviceNames = ""
    for serviceName in serviceNamesToValuesMap.keys():
        if hasattr(deployed.ServiceNames, serviceName) and getattr(deployed.ServiceNames, serviceName):
            serviceNames = serviceNames + serviceNamesToValuesMap[serviceName] + ";"
    if serviceNames != "":
        serviceNames = serviceNames[:-1]
    return serviceNames

def inspectServiceNamesProperties(deployedId, resourceId, propertyPrefix, attributeName):
    values = noneToEmpty(AdminConfig.showAttribute(resourceId, attributeName)).split(";")
    for value in values:
        if valuesToServiceNamesMap.has_key(value):
            serviceName = valuesToServiceNamesMap[value]
            inspectedProperty(deployedId,"%s%s" % (propertyPrefix, serviceName), "true")


