from java.util import HashSet
import re
import os

def parseUri(line):
    return line.split(": ")[1].split(",")[0].strip()

########################################################################################################################
#
# DEPRECATED FUNCTIONS - TO BE REMOVED IN FUTURE VERSION
#
########################################################################################################################
def getVirtualHostNameForApp(appName):
    printError("The usage of function 'getVirtualHostNameForApp' is deprecated.")
    for virtualHost in getVirtualHostNames(appName).values():
        return virtualHost
    print "Cannot resolve virtual host for %s" % appName

def resolveWebServers(appName):
    printError("The usage of function 'resolveWebServers' is deprecated.")
    webServers = []
    for moduleServers in getWebServers(appName).values():
        for moduleServer in moduleServers:
            if moduleServer not in webServers:
                webServers.append(moduleServer)
    return webServers

def getJspClassReloading(appName):
    printError("The usage of function 'getJspClassReloading' is deprecated.")
    for opts in getJspClassReloadingOpts(appName).values():
        return opts

def getWarClassloaderMode(appName, deploymentObjectId):
    printError("The usage of function 'getWarClassloaderMode' is deprecated.")
    for module in wsadminToList(AdminConfig.showAttribute(deploymentObjectId, "modules")):
        if isWebModule(module):
            return AdminConfig.showAttribute(module, "classloaderMode")
    return None
########################################################################################################################
# Given an application name, will try to find the context root. Fails if cannot be resolved.
########################################################################################################################
def getContextRoot(appName):
    for contextRoot in getContextRoots(appName).values():
        return contextRoot
    printErrorAndExit("Cannot resolve context root for %s" % appName)

def getContextRoots(appName):
    data = {}
    module = ""
    appData = AdminApp.view(appName,["-CtxRootForWebMod"]).splitlines()
    for line in appData:
        if line.startswith("URI"):
            module = parseUri(line)
        if line.startswith("Context Root: ") or line.startswith("ContextRoot: "):
            data[module] = line.split(": ")[1].strip()
    return data

########################################################################################################################
# Given an application name, will try to find associated virtual hosts.
########################################################################################################################
def getVirtualHostNames(appName):
    data = {}
    module = ""
    appData = AdminApp.view(appName,["-MapWebModToVH"]).splitlines()
    for line in appData:
        if line.startswith("URI"):
            module = parseUri(line)
        if line.startswith("Virtual host: "):
            data[module] = line.split(": ")[1].strip()
    return data

########################################################################################################################
# Given an application name, will find all shared libraries associated with it.
########################################################################################################################
def resolveSharedLibraries(appName):
    sharedLibs = getSharedLibraries(appName)
    return sharedLibs.get(appName, [])

def getSharedLibraries(appName):
    data = {}
    module = ""
    appData = AdminApp.view(appName,["-MapSharedLibForMod"]).splitlines()
    for line in appData:
        if line.startswith("URI"):
            if line.find("application.xml") > -1:
                module = appName
            else:
                module = parseUri(line)
        if line.startswith("Shared Libraries: ") and line.strip() != "Shared Libraries:" and line.strip() != "Shared Libraries: null":
            #Shared Libraries:  WebSphere:name=itest-shared-library,isSharedClassloader=true+WebSphere:name=MYTestSharedList,isSharedClassloader=true
            sharedLibraryNames = []
            sharedLibsLine = line.split(": ")[1].strip()
            if sharedLibsLine != 'null':    # WS7.0
                sharedLibsLine = sharedLibsLine.split("WebSphere:name=")
                sharedLibsLine = [l.split(",")[0] for l in sharedLibsLine if l]
                for sl in sharedLibsLine:
                    if sl not in sharedLibraryNames:
                        sharedLibraryNames.append(sl)
            data[module] = sharedLibraryNames
    return data

########################################################################################################################
# Given an application name, will find all web servers associated with it.
########################################################################################################################
def getWebServers(appName):
    data = {}
    module = ""
    appData = AdminApp.view(appName,["-MapModulesToServers"]).splitlines()
    for line in appData:
        if line.startswith("URI"):
            module = parseUri(line)
        if line.startswith("Server: ") and line.strip() != "Server:" and line.strip() != "Server: null":
            #Server:  WebSphere:cell=vagrantCell01,node=vagrantNode01,server=existing-server+WebSphere:cell=vagrantCell01,node=vagrantNode01,server=webserver1
            webServers = []
            serversLine = line.split(": ")[1].strip()
            for webServer in serversLine.split("+"):
                if webServer.find("node=") < 0: continue # not a webServer, probably a cluster
                webServer = webServer.split(",config")[0] # WAS6.1 - WebSphere:cell=vagrantCell01,node=vagrantNode01,server=webserver1,config=null
                serverContainmentPath = convertWebTargetToContainmentPath(webServer)
                serverId = AdminConfig.getid(serverContainmentPath)
                if serverId != "":
                    wasServerType = AdminConfig.showAttribute(serverId, 'serverType')
                    if wasServerType == 'WEB_SERVER':
                        webServers.append(webServer)
            data[module] = webServers
    return data

########################################################################################################################
# Given an application name, will find all security roles associated with it.
# @returns a Map. Key is roleName. Value is pipe separated string with groups.
########################################################################################################################
def getSecurityRoleMappings(appName, scope = "GROUP"):
    mappings = {}
    appData = AdminApp.view(appName,["-MapRolesToUsers"]).splitlines()
    currentRole = None
    for line in appData:
        if line.startswith("Role: "):
            currentRole = line.split(": ")[1].strip()
        if currentRole is None:
            continue

        if scope == "GROUP":
            if line.startswith("Everyone?:  Yes"):
                mappings[currentRole] = "Everyone"
            elif line.startswith("All authenticated?:  Yes"):
                mappings[currentRole] = "AllAuthenticated"
            elif line.startswith("All authenticated in trusted realms?:  Yes"):
                mappings[currentRole] = "AllAuthenticatedInTrustedRealms"
            elif line.startswith("Mapped groups: "):
                groups = line.split(": ")[1].strip()
                if groups:
                    mappings[currentRole] = groups

        if scope == "USER":
            if line.startswith("Mapped users: "):
                users = line.split(": ")[1].strip()
                if users:
                    mappings[currentRole] = users

    return mappings

def findApplicationModuleType(appName):
    earName = appName
    edtIdx = appName.rfind("-edition")
    if edtIdx > -1:
        earName = appName[:edtIdx]

    descriptorFile = "%s/config/cells/%s/applications/%s.ear/deployments/%s/META-INF/application.xml" %(container.wasHome, container.cellName, earName, appName)
    # If add annotation to ear file. WAS change application.xml to application_merged.xml
    if not os.path.isfile(descriptorFile):
        descriptorFile = "%s/config/cells/%s/applications/%s.ear/deployments/%s/META-INF/application_merged.xml" %(container.wasHome, container.cellName, earName, appName)
    appxml =  open(descriptorFile, 'r').read()
    start_string = "<display-name>"
    end_string = "</display-name>"
    start_index = appxml.find(start_string) + len(start_string)
    end_index = appxml.find(end_string)
    displayName = appxml[start_index:end_index]
    if re.match( r'.+([0-9a-f]{10,})', displayName) or displayName.endswith("_jar") or displayName.endswith("_war"):
        module = AdminApp.listModules(appName).splitlines()
        if len(module) == 1:
            if module[0].endswith("META-INF/ejb-jar.xml"):
                return "ejb"
            elif module[0].endswith("WEB-INF/web.xml"):
                return "war"

    return "ear"

def getJsfImplementation(appName):
    if getVersion(container) != 'WAS_61':
        jsfImplementation = AdminTask.listJSFImplementation(appName)
        if jsfImplementation.lower() != "default":
            return jsfImplementation

def getJspClassReloadingOpts(appName):
    data = {}
    module = ""
    jspReloadOpts = {}
    appData = AdminApp.view(appName,["-JSPReloadForWebMod"]).splitlines()
    for line in appData:
        if line.startswith("URI"):
            module = parseUri(line)
            if getVersion(container) == 'WAS_70' and line.endswith("WEB-INF/ibm-web-ext.xmi"):
                jspReloadOpts["enableWorkaroundForJavaEE4inWAS7"] = "True"

        if line.startswith("JSP enable class reloading: "):
            jspReloadOpts["enableJspClassReloading"] = {True: "True", False: "False"}[line.split(": ")[1].strip().lower() == "yes"]

        if line.startswith("JSP reload interval in seconds: "):
            jspReloadOpts["jspReloadInterval"] = line.split(": ")[1].strip()
            data[module] = jspReloadOpts
            jspReloadOpts = {}

    return data

def getClassloaderMode(appName, deploymentObjectId):
    classLoader= AdminConfig.showAttribute(deploymentObjectId, "classloader")
    return AdminConfig.showAttribute(classLoader, "mode")

def getModuleDestination(appName, deploymentObjectId):
   binariesUrl = AdminConfig.showAttribute(deploymentObjectId, "binariesURL")
   if binariesUrl:
       fileStart = binariesUrl.rfind("/")
       if fileStart > -1:
           return binariesUrl[:fileStart]
   return None

########################################################################################################################
#
# Function to discover and inspect applications running on the given Deployit container (scope).
# Security role mappings and shared libraries are automatically discovered/inspected.
# Use the callback mechanism to inspect additional properties.
#
# c : The container on which applications must be discovered.
#
# canHandleAppTypeCallback :  when application is found this function is called to check if caller can handle app type.
#     appType - Can be 'war','ejb' or 'ear'
#
# appInspectCallback : if the caller wishes to inspect additional information.
#     deployedId - id of discovered ci.
#     application - application name.
#     wasDeploymentObjectId - WAS deployment object id for the application.
#     container - the deployit container on which the application was discovered.
#
########################################################################################################################
def discoverAndInspectAppModules(c, canHandleAppTypeCallback, appInspectCallback=None):
    scope = None
    if c.wasTargetType == "cluster":
        scope = "WebSphere:cell=%s,cluster=%s" %(container.name, c.name)
    else:
        scope = "WebSphere:cell=%s,node=%s,server=%s" %(container.cellName, c.node.nodeName, c.name)

    apps = AdminApp.list(scope)
    if apps == "":
        return

    for app in apps.splitlines():
        appModuleType = findApplicationModuleType(app)
        if not canHandleAppTypeCallback(appModuleType):
            print app, " %s of type %s is not a %s. Skipping." % (app, appModuleType, prototype.type)
            continue
        if appendTypeToName:
            deployedId = c.id + '/' + app + '_' + prototype.type
        else:
            deployedId = c.id + '/' + app
        discovered(deployedId, prototype.type)
        inspectedProperty(deployedId, 'wasName', app)

        deploymentId = AdminConfig.getid("/Deployment:%s" % (app))
        deploymentObjectId = AdminConfig.showAttribute(deploymentId, "deployedObject")

        ignoredProps = getUnsupportedTypeAttrs("ApplicationDeployment", prototype.getExposedProperties(True).keys(), False)
        ignoredProps.append('name')
        inspectDeployedProperties(deployedId, app, deploymentObjectId, prototype, ignoredProps)

        roleGroupMappings = getSecurityRoleMappings(app, "GROUP")
        if len(roleGroupMappings.keys()) > 0:
            inspectedProperty(deployedId, "roleMappings", roleGroupMappings)

        roleUserMappings = getSecurityRoleMappings(app, "USER")
        if len(roleUserMappings.keys()) > 0:
            inspectedProperty(deployedId, "roleUserMappings", roleUserMappings)

        sharedLibs = resolveSharedLibraries(app)
        if len(sharedLibs) > 0:
            inspectedProperty(deployedId, "sharedLibraryNames", sharedLibs)

        classloaderMode = getClassloaderMode(app, deploymentObjectId)
        if classloaderMode:
            inspectedProperty(deployedId, "classloaderMode", classloaderMode)
        
        warClassloaderMode = getWarClassloaderMode(app, deploymentObjectId)
        if warClassloaderMode:
            inspectedProperty(deployedId, "warClassloaderMode", warClassloaderMode)
        
        virtualHostName = getVirtualHostNameForApp(app)
        if virtualHostName:
            inspectedProperty(deployedId, "virtualHostName", virtualHostName)

        inspectedProperty(deployedId, "moduleDestination", getModuleDestination(app, deploymentObjectId))

        discoverAndInspectModules(deployedId, app, deploymentObjectId)
        discoverAndInspectNestedReferences(deployedId, app)

        if  appInspectCallback:
            appInspectCallback(deployedId, app, deploymentObjectId, c)

        inspectedItem(deployedId)

def discoverAndInspectModules(appId, appName, deploymentObjectId):
    contextRoots = getContextRoots(appName)
    jspReloadingOpts = getJspClassReloadingOpts(appName)
    sharedLibs = getSharedLibraries(appName)
    vhostNames = getVirtualHostNames(appName)
    webServers = getWebServers(appName)

    for module in getModules(deploymentObjectId):
        type = "was.EmbeddedEjbModule"
        if isWebModule(module):
            type = "was.EmbeddedWebModule"

        name = AdminConfig.showAttribute(module, "uri")
        deployedId = "%s/%s" % (appId, name)
        if appendTypeToName:
            deployedId = deployedId + "_" + type
        discovered(deployedId, type)
        inspectedProperty(deployedId, 'wasName', name)
        inspectedProperty(deployedId, "startingWeight", AdminConfig.showAttribute(module, "startingWeight"))
        inspectedProperty(deployedId, "sharedLibraryNames", sharedLibs.get(name))
        if isWebModule(module):
            inspectedProperty(deployedId, "classloaderMode", AdminConfig.showAttribute(module, "classloaderMode"))
            inspectedProperty(deployedId, "contextRoot", contextRoots.get(name))
            inspectedProperty(deployedId, "virtualHostName", vhostNames.get(name))
            inspectedProperty(deployedId, "webServerNames", webServers.get(name))
            for key, value in jspReloadingOpts.get(name,{}).items():
                inspectedProperty(deployedId, key, value)
        inspectedItem(deployedId)

def discoverAndInspectNestedReferences(appId, appName):
    mappings = {0: 'moduleName', 1: 'ejbName', 2: 'uri', 3: 'resourceRefName', 4: 'resourceType', 5: 'resourceJndiName'}
    discoverAndInspectNestedReference(appId, appName, "was.EjbRef", "-MapEJBRefToEJB", mappings)
    discoverAndInspectNestedReference(appId, appName, "was.ResourceEnvRef", "-MapResEnvRefToRes", mappings)
    mappings.update({6: 'loginConfigurationName', 7: 'properties'})
    discoverAndInspectNestedReference(appId, appName, "was.ResourceRef", "-MapResRefToEJB", mappings)

def discoverAndInspectNestedReference(appId, appName, type, wasAdminAppCmd, lineMappings):
    refData = AdminApp.view(appName,[wasAdminAppCmd]).splitlines()
    refs = []
    currentRef = None
    refIdx = 0
    for line in refData:
        if line.startswith("Module:"):
            if currentRef:
                refs.append(currentRef)
            refIdx = 0
            currentRef = {}
        if currentRef != None:
            propName = lineMappings.get(refIdx)
            if propName:
                currentRef[propName] = line.split(":")[1].strip().replace('null','')
            refIdx+=1
    if currentRef:
        refs.append(currentRef)

    for ref in refs:
        moduleName = ref.get('uri').split(",")[0].strip()
        refName = sanitize(ref.get('resourceRefName'))

        deployedId = "%s/%s/%s" % (appId, moduleName, refName)
        if appendTypeToName:
            if moduleName.encode('ascii', 'ignore').endswith('.war'):
                moduleName = moduleName + '_was.EmbeddedWebModule'
            elif moduleName.encode('ascii', 'ignore').endswith('.jar'):
                moduleName = moduleName + '_was.EmbeddedEjbModule'

            if type.startswith('was.'):
                deployedId = "%s/%s/%s" % (appId, moduleName, refName) + '_' + type
            else:
                deployedId = "%s/%s/%s" % (appId, moduleName, refName) + '_was.' + type

        discovered(deployedId, type)
        inspectedProperty(deployedId, 'wasName', refName)
        for propName in ref.keys():
            if propName not in ["moduleName", "uri"]:
                inspectedProperty(deployedId, propName, ref.get(propName))
        inspectedItem(deployedId)

def discoverAndInspectNestedSessionManagers(appId, appName, deploymentObjectId):
    discoverAndInspectNestedSessionManager(deploymentObjectId, appId, appName, "APPLICATION")
    for module in getWebModules(deploymentObjectId):
        uri = AdminConfig.showAttribute(module, "uri")
        discoverAndInspectNestedSessionManager(module, "%s/%s" % (appId, uri), uri , "MODULE")

def discoverAndInspectNestedSessionManager(parent, parentId, parentName, scope):
    print "Inspecting session manager settings for '%s' and scope '%s'" % (parentName, scope)
    for config in wsadminToList(AdminConfig.showAttribute(parent, "configs")):
        sessionManagement = AdminConfig.showAttribute(config, "sessionManagement")
        if sessionManagement:
            deployedId = "%s/SessionManager" % parentId
            if appendTypeToName:
                deployedId = deployedId + "_was.SessionManager"

            discovered(deployedId, "was.SessionManager")
            inspectedProperty(deployedId, 'wasName', 'SessionManager')
            inspectNestedObjectProperties(deployedId, sessionManagement)
            tuningParams = AdminConfig.showAttribute(sessionManagement, "tuningParams")
            inspectNestedObjectProperties(deployedId, tuningParams, "TuningParams_")
            inspectNestedObjectProperties(deployedId, AdminConfig.showAttribute(tuningParams, "invalidationSchedule"), "InvalidationSchedule_")
            inspectNestedObjectProperties(deployedId, AdminConfig.showAttribute(sessionManagement, "defaultCookieSettings"), "Cookie_")
            inspectNestedObjectProperties(deployedId, AdminConfig.showAttribute(sessionManagement, "sessionDatabasePersistence"), "SessionDatabasePersistence_")
            inspectNestedObjectProperties(deployedId, AdminConfig.showAttribute(sessionManagement, "sessionDRSPersistence"), "DRSSettings_")
            inspectedItem(deployedId)

def inspectNestedObjectProperties(deployedId, attributeId, nestedProperty = ""):
    if not attributeId:
        return
    attributes = AdminConfig.show(attributeId)
    attrMap = wsadminToDict(attributes)
    for key in attrMap.keys():
        inspectedProperty(deployedId, "%s%s"  % (nestedProperty, key), attrMap[key])
