def discoverPMI(container):
    if (container.wasConfigIdType == 'Server'):
        appServerId = AdminConfig.getid('/Node:%s/Server:%s' % (container.nodeName, container.name))
        print "Inspecting PMIService on server: %s" % appServerId
        for objectId in wsadminToList(AdminConfig.list(prototype.wasType, appServerId)):
            name = 'PMIService'
            if appendTypeToName:
                deployedId = container.id + '/' + name + '_' + prototype.type
            else:
                deployedId = container.id + '/' + name

            discovered(deployedId, prototype.type)
            inspectedProperty(deployedId, 'wasName', name)
            ignoredProperties = ['name', 'customModuleMetrics']
            ignoredProperties.extend(getUnsupportedTypeAttrs(prototype.wasType, prototype.getExposedProperties(True).keys()))
            inspectDeployedProperties(deployedId, name, objectId, prototype, ignoredProperties)
            # custom inspection:
            pmiRootModule = AdminConfig.list('PMIModule', objectId)
            pmiModules = {}
            statisticSet = AdminConfig.showAttribute(objectId, 'statisticSet')
            if statisticSet == 'custom':
                moduleMetrics = {}
                for moduleId in wsadminToList(AdminConfig.showAttribute(pmiRootModule, "pmimodules")):
                    metrics = AdminConfig.showAttribute(moduleId, 'enable')
                    if metrics:
                        moduleName = AdminConfig.showAttribute(moduleId, 'moduleName')
                        moduleMetrics[moduleName] = metrics
                print "module metrics:%s" % moduleMetrics
                inspectedProperty(deployedId, 'customModuleMetrics', moduleMetrics)
            #
            inspectedItem(deployedId)

for c in findAllContainers(container, onlyWasAppContainer=True):
    discoverPMI(c)
