package com.xebialabs.deployit.plugin.was.contributor;

import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.was.container.BaseCluster;
import com.xebialabs.deployit.plugin.was.container.ManagedServer;
import com.xebialabs.deployit.plugin.was.container.WasContainer;
import com.xebialabs.deployit.plugin.was.util.ContainerRestartStrategy;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import static com.google.common.collect.Sets.newHashSet;
import static com.google.common.collect.Sets.symmetricDifference;

public class StopStartCoreGroupContributor extends StopStartContainer {

    @Contributor
    public static void stopAndStartCoreGroupServers(Deltas deltas, DeploymentPlanningContext ctx) {
        StopStartCoreGroupContributor contributor = new StopStartCoreGroupContributor();
        contributor.doStopAndStartContainers(deltas, ctx);
    }

    @Override
    protected void findContainers(Deltas deltas, Set<WasContainer> stopStartContainers, Set<WasContainer> restartStartContainers) {
        for (Delta delta : deltas.getDeltas()) {
            final Set<WasContainer> previousContainers = findReferencedCoreGroupServers(delta.getPrevious(), delta.getOperation());
            final Set<WasContainer> currentContainers = findReferencedCoreGroupServers(delta.getDeployed(), delta.getOperation());

           //RESTART strategy does not work with Core group deployment,  all the servers should be stopped before core group deployment so only STOP_START strategy can be used
            stopStartContainers.addAll(symmetricDifference(previousContainers, currentContainers));
        }
    }

    private Set<WasContainer> findReferencedCoreGroupServers(final Deployed<?, ?> deployed, Operation operation) {
        HashSet<WasContainer> containers = newHashSet();

        if (deployed != null && isOperationNoop(operation) && !applyRestartStrategyForNoop(deployed)) {
            return containers;
        }

        if(!isApplicable(deployed)) {
            return containers;
        }

        Collection<ManagedServer> coreGroupServers = deployed.getProperty("coreGroupServers");
        if(coreGroupServers != null) {
            containers.addAll(coreGroupServers);
        }

        Collection<BaseCluster> coreGroupClusters = deployed.getProperty("coreGroupClusters");
        if(coreGroupClusters != null) {
            for (BaseCluster coreGroupCluster : coreGroupClusters) {
                containers.addAll(coreGroupCluster.getServers());
            }
        }

        return containers;
    }

    private boolean isApplicable(final Deployed<?, ?> deployed) {
        return deployed != null
                && deployed.getType().instanceOf(Type.valueOf("was.CoreGroup"))
                && deployed.hasProperty(CONTAINER_RESTART_STRATEGY)
                && deployed.getProperty(CONTAINER_RESTART_STRATEGY) != ContainerRestartStrategy.NONE;
    }
}
