package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.was.container.Cell;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.xlplatform.satellite.Satellite;
import com.xebialabs.xlplatform.satellite.SatelliteAware;

import static com.xebialabs.overthere.OperatingSystemFamily.UNIX;

@SuppressWarnings("serial")
public class CheckWasInstallationStep implements Step, SatelliteAware {

    private Cell cell;

    private boolean validInstallation;

    public CheckWasInstallationStep(Cell cell) {
        this.cell = cell;
    }

    @Override
    public int getOrder() {
        return 50;
    }

    @Override
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        OverthereConnection c = cell.getHost().getConnection();
        try {
            validInstallation = true;
            checkDirectoryExistence(ctx, c, cell.getWasHome());
            checkDirectoryExistence(ctx, c, cell.getConfigDirPath());
            checkFileExistenceAndExecutability(ctx, c, cell.getVersionInfoPath());
            checkFileExistenceAndExecutability(ctx, c, cell.getWsadminPath());

            return validInstallation ? StepExitCode.SUCCESS : StepExitCode.FAIL;
        } finally {
            c.close();
        }
    }

    protected void checkDirectoryExistence(ExecutionContext ctx, OverthereConnection c, String dirPath) {
        ctx.logOutput("Checking whether directory " + dirPath + " exists on " + cell.getHost());

        if(!c.getFile(dirPath).exists()) {
            ctx.logError("Directory " + dirPath + " does not exist on " + cell.getHost());
            validInstallation = false;
        }
    }

    private void checkFileExistenceAndExecutability(ExecutionContext ctx, OverthereConnection c, String filePath) {
        ctx.logOutput("Checking whether file " + filePath + " exists on " + cell.getHost() + " exists" + (c.getHostOperatingSystem() == UNIX ? " and is executable" : ""));

        if(!c.getFile(filePath).exists()) {
            ctx.logError("File " + filePath + " does not exist on " + cell.getHost());
            validInstallation = false;
        } else if(c.getHostOperatingSystem() == UNIX && !c.getFile(filePath).canExecute()) {
            ctx.logError("File " + filePath + " on " + cell.getHost() + " is not executable");
            validInstallation = false;
        }
    }

    @Override
    public String getDescription() {
        return "Checking whether " + cell + " is a valid WebSphere Application Server installation";
    }

    @Override
    public Satellite getSatellite() {
        return cell.getManagingContainer().getHost().getSatellite();
    }

}
