/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasNode;
import com.xebialabs.deployit.plugin.was.ci.WasScope;
import com.xebialabs.deployit.plugin.was.ci.WasServer;
import com.xebialabs.deployit.plugin.was.ci.WasSharedLibrary;

@SuppressWarnings("serial")
public class CreateWasSharedLibraryStep extends WasStepBase {

	public static final String CREATE_DATASOURCE_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "create-shared-library.py";

	private WasSharedLibrary sharedLibrary;
	private WasScope scopeTarget;
	private String fullClassPath;

	public CreateWasSharedLibraryStep(WasSharedLibrary library, WasScope scopeTarget, String fullClassPath) {
		super(scopeTarget.getCell());
		this.sharedLibrary = library;
		this.scopeTarget = scopeTarget;
		this.fullClassPath = fullClassPath;
		String description = "Create shared library " + library;
		if (scopeTarget instanceof WasNode) {
			WasNode node = (WasNode) scopeTarget;
			description += "on Node:" + node.getNodeName();
		} else if (scopeTarget instanceof WasCluster) {
			WasCluster cluster = (WasCluster) scopeTarget;
			description += "on Cluster:" + cluster.getName();
		} else if (scopeTarget instanceof WasServer) {
			WasServer server = (WasServer) scopeTarget;
			description += "on Server:" + server.getName();
		}

		setDescription("Create shared library " + library + " in cell " + scopeTarget.getCell());
	}

	public boolean execute(StepExecutionContext ctx) {
		String targetContainmentPath = getTagetContainmentPath();
		return executeWsadminJythonScriptResource(ctx, CREATE_DATASOURCE_SCRIPT_RESOURCE_PATH, targetContainmentPath, sharedLibrary.getName(), fullClassPath) == 0;
	}

	private String getTagetContainmentPath() {
		if (scopeTarget instanceof WasNode) {
			WasNode node = (WasNode) scopeTarget;
			return "/Node:" + node.getNodeName() + "/";
		} else if (scopeTarget instanceof WasCluster) {
			WasCluster cluster = (WasCluster) scopeTarget;
			return "/ServerCluster:" + cluster.getName() + "/";
		} else if (scopeTarget instanceof WasServer) {
			WasServer server = (WasServer) scopeTarget;
			return "/Server:" + server.getName() + "/";
		}
		throw new IllegalArgumentException("Wrong wasScopeTarget was used for creating was shared library " + scopeTarget.getClass());
	}
}
