/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.step;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasSibJmsQueueConnectionFactory;
import com.xebialabs.deployit.plugin.was.ci.WasTarget;
import com.xebialabs.deployit.plugin.was.ci.WasWmqQueueConnectionFactory;

/**
 * Destroys a {@link WasWmqQueueConnectionFactory} in a {@link WasTarget}
 */
@SuppressWarnings("serial")
public class DestroyWasSibJmsQueueConnectionFactoryStep extends WasStepBase {
	private static String DESTROY_SIB_JMS_QCF_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "destroy-sib-jms-queue-connection-factory.py";

	private WasTarget target;

	private WasSibJmsQueueConnectionFactory qcf;

	public DestroyWasSibJmsQueueConnectionFactoryStep(WasTarget target, WasSibJmsQueueConnectionFactory qcf) {
		super(target.getCell());
		this.target = target;
		this.qcf = qcf;
		setDescription("Destroy WebSphere Queue Connection Factory (Default messaging provider) " + qcf + " in " 
				+ target.getShortTypeDescription() + " " + target);
	}

	public boolean execute(StepExecutionContext ctx) {
		Map<String, Serializable> context = new HashMap<String, Serializable>();
		context.put("qcf", qcf);

		String jmsQueueConnectionFactoryContainmentPath = "/" + target.getWasConfigIdType() + ":" + target.getName()
				+ "/J2CResourceAdapter:SIB JMS Resource Adapter/J2CConnectionFactory:" + qcf.getName();
		int res = executeWsadminJythonScriptResource(ctx, context, DESTROY_SIB_JMS_QCF_SCRIPT_RESOURCE_PATH, jmsQueueConnectionFactoryContainmentPath);
		return res == 0;
	}

}
