/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.step;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.was.ci.WasFileServing;
import com.xebialabs.deployit.plugin.was.ci.WasTarget;

/**
 * Sets the {@link WasFileServing} property in an ibm-web-ext.xmi file of an application.
 */
@SuppressWarnings("serial")
public class UpdateWasFileServingEnabledStep extends WasStepBase {

	protected NamedDeployableArtifact application;
	private String warName;
	private WasTarget target;
	private WasFileServing fileServingEnabled;

	public UpdateWasFileServingEnabledStep(NamedDeployableArtifact application, WasTarget target, String warName, WasFileServing fileServingEnabled) {
		super(target.getCell());
		this.application = application;
		this.target = target;
		this.warName = warName;
		this.fileServingEnabled = fileServingEnabled;
		setDescription("Setting  File Serving Enabled to  " + warName + " in application " + application.getName() + " in cell " + target.getCell());
	}

	public boolean execute(StepExecutionContext ctx) {
		if (fileServingEnabled != null && fileServingEnabled != WasFileServing.DO_NOT_OVERRIDE) {
			return setFileServingEnabledPropertyOnHost(ctx);
		}
		return false;
	}

	private boolean setFileServingEnabledPropertyOnHost(StepExecutionContext ctx) {

		boolean isSuccess = true;
		String appName = application.getName();
		String hostPath = getWarWebExtFilePath();
		File localFile = getLocalFile(hostPath, ctx);
		HostSession session = target.getCell().connectToAdminHost();
		HostFile configLocationWriteFile = session.getFile(hostPath);
		String backupPath = getWarWebExtBackupFilePath();
		HostFile backupWriteFile = session.getFile(backupPath);
		HostSession lhs = Host.getLocalHost().getHostSession();
		try {
			InputStream is = new FileInputStream(localFile);
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder db = dbf.newDocumentBuilder();
			Document doc = db.parse(new InputSource(is));
			Node mainNode = doc.getFirstChild();
			if (mainNode != null) {
				Element element = (Element) mainNode;
				NamedNodeMap attr = element.getAttributes();
				Node nodeAttr = attr.getNamedItem("fileServingEnabled");
				if (nodeAttr == null) {
					nodeAttr = doc.createAttribute("fileServingEnabled");
					nodeAttr.setNodeValue(fileServingEnabled.toString().toLowerCase());
					attr.setNamedItem(nodeAttr);
				} else {
					nodeAttr.setNodeValue(fileServingEnabled.toString().toLowerCase());
				}
				// write the content into xml file
				TransformerFactory transformerFactory = TransformerFactory.newInstance();
				Transformer transformer = transformerFactory.newTransformer();
				DOMSource source = new DOMSource(doc);
				StreamResult result = new StreamResult(localFile);
				transformer.transform(source, result);

				HostFile applicationFileToUpload = lhs.getFile(localFile.getAbsolutePath());
				HostFileUtils.copy(applicationFileToUpload, configLocationWriteFile);
				ctx.logOutput("Successfully updated File serving enabled property in ibm-web-ext-xmi file");
				HostFileUtils.copy(configLocationWriteFile, backupWriteFile);
				ctx.logOutput("Successfully copied back up file of ibm-web-ext-xmi file");
			}
		} catch (IOException e) {
			ctx.logError("IO Exception occured " + appName);
			isSuccess = false;
		} catch (ParserConfigurationException e) {
			ctx.logError("parser configuration exception when preparing to parse binding file for app " + appName);
			isSuccess = false;
		} catch (SAXException e) {
			ctx.logError("SAX exception occured when parsing binding file for app " + appName);
			isSuccess = false;
		} catch (TransformerConfigurationException tce) {
			ctx.logError("TransformerConfiguration error occured while creating a Transformer " + appName);
			isSuccess = false;
		} catch (TransformerException e) {
			ctx.logError("Transformer exception in the course of transformation " + appName);
			isSuccess = false;
		} finally {
			localFile.delete();
			lhs.close();
			session.close();
		}
		if (!isSuccess) {
			ctx.logError("Failed to update File serving enabled property");
		}
		return isSuccess;
	}

	private String getWarWebExtBackupFilePath() {
		Date date = GregorianCalendar.getInstance().getTime();
		SimpleDateFormat sdf = new SimpleDateFormat("MM-dd-yyyy-HHmmss");
		String dateString = sdf.format(date);
		String backupPath = target.getCell().getConfigDirPath() + "/cells/" + target.getCell().getCellName() + "/applications/" + application.getName()
		        + ".ear/deployments/" + application.getName() + "/" + warName + "/WEB-INF/ibm-web-ext-xmi-" + dateString + ".bk";
		return backupPath;
	}

	private String getWarWebExtFilePath() {
		String hostPath = target.getCell().getConfigDirPath() + "/cells/" + target.getCell().getCellName() + "/applications/" + application.getName()
		        + ".ear/deployments/" + application.getName() + "/" + warName + "/WEB-INF/ibm-web-ext.xmi";
		return hostPath;
	}

	private File getLocalFile(String hostPath, StepExecutionContext ctx) {
		String appName = application.getName();
		HostSession session = target.getCell().connectToAdminHost();
		HostFile remoteBindingFile = session.getFile(hostPath);
		File localFile = null;
		try {
			localFile = File.createTempFile("theBindingFile", null);
			remoteBindingFile.get(localFile);
		} catch (IOException e) {
			ctx.logError("IO exception when copying a hostfile to a file " + localFile);
		} finally {
			session.close();
		}
		return localFile;
	}

	public NamedDeployableArtifact getApplication() {
		return application;
	}

	public String getWarName() {
		return warName;
	}

	public WasFileServing getFileServingEnabled() {
		return fileServingEnabled;
	}

}
