/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.runbook;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.Environment;
import com.xebialabs.deployit.plugin.was.ci.WasServer;
import com.xebialabs.deployit.reflect.ConfigurationItemReflectionUtils;
import com.xebialabs.deployit.util.SingleTypeHandlingRunBook;
import java.io.Serializable;
import java.util.List;

abstract class WasServerRunBook<T extends WasServer>
extends SingleTypeHandlingRunBook<T> {
    public WasServerRunBook(Class<T> serverType) {
        super(serverType);
    }

    public void resolve(Change<T> change, ChangePlan changePlan, List<Step> steps) {
        WasServer newServer;
        WasServer oldServer = (WasServer)change.getOldRevision();
        if (!ConfigurationItemReflectionUtils.isIdentical((Serializable)oldServer, (Serializable)(newServer = (WasServer)change.getNewRevision())) && this.isEligibleChange(change, changePlan)) {
            if (change.isModification() && !this.serverEnvironmentBeingDeployedTo(change, changePlan)) {
                this.getStepsForModifiedServer(steps, oldServer, newServer);
            }
            if (change.isDeletion()) {
                this.getStepsForDeletedServer(steps, oldServer);
            }
            if (change.isAddition()) {
                this.getStepsForAddedServer(steps, newServer);
            }
        }
    }

    protected abstract boolean isEligibleChange(Change<T> var1, ChangePlan var2);

    protected abstract void getStepsForDeletedServer(List<Step> var1, T var2);

    protected abstract void getStepsForModifiedServer(List<Step> var1, T var2, T var3);

    protected abstract void getStepsForAddedServer(List<Step> var1, T var2);

    private boolean serverEnvironmentBeingDeployedTo(Change<T> serverChange, ChangePlan changePlan) {
        return this.findDeploymentToModifiedServersEnvironment(serverChange, changePlan) != null;
    }

    private Change<Deployment> findDeploymentToModifiedServersEnvironment(Change<T> serverChange, ChangePlan changePlan) {
        for (Change change : changePlan.getChanges()) {
            if (!change.isModification() || !Deployment.class.isAssignableFrom(change.getConfigurationItemClass())) continue;
            Deployment oldDeployment = (Deployment)change.getOldRevision();
            Deployment newDeployment = (Deployment)change.getNewRevision();
            if (!WasServerRunBook.isMember(oldDeployment.getTarget(), (WasServer)serverChange.getOldRevision()) || !WasServerRunBook.isMember(newDeployment.getTarget(), (WasServer)serverChange.getNewRevision())) continue;
            return change;
        }
        return null;
    }

    private static boolean isMember(Environment environment, WasServer server) {
        return environment.getMembersOfType(WasServer.class).contains(server);
    }
}

