/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.utils;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.plugin.was.ci.SecurityRoleUserGroupMappings;

public class WasWarUtils {

	public static Set<String> getSecurityRoles(War war) {
		Set<String> securityRolesList = new HashSet<String>();
		NodeList securityRoles = WasUtils.getNodesWithTag("security-role", war, "WEB-INF/web.xml");
		if (securityRoles != null) {
			for (int i = 0; i < securityRoles.getLength(); i++) {
				Element securityRole = (Element) securityRoles.item(i);
				String name = WasUtils.findName(securityRole, "role-name");
				if (name != null) {
					securityRolesList.add(name);
				}
			}
		}
		return securityRolesList;
	}

	public static List<SecurityRoleUserGroupMappings> getSecurityRoleUserGroupMappings(War source) {
		List<SecurityRoleUserGroupMappings> securityRoleUserGroupMappingsList = Lists.newArrayList();
		Set<String> securityroles = getSecurityRoles(source);
		for (String roleName : securityroles) {
			SecurityRoleUserGroupMappings securityRoleUserGroupMapping = new SecurityRoleUserGroupMappings(roleName, "", "");
			securityRoleUserGroupMappingsList.add(securityRoleUserGroupMapping);
        }
		return securityRoleUserGroupMappingsList;
	}
}

