/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.ci;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.StepExecutionContextCallbackHandler;
import com.xebialabs.deployit.StepExecutionContextListener;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.CommandExecution;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.plugin.was.utils.RegexUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class WasCellConfigurationExecutor {
    public static final String GET_OBJECT_BY_CONTAINMENT_PATH_SCRIPT = "com/xebialabs/deployit/plugin/was/step/get-object-by-containment-path.py";
    public static final String GET_OBJECT_BY_CONTAINMENT_PATH_AND_SUBLEVEL_TYPE_SCRIPT = "com/xebialabs/deployit/plugin/was/step/get-object-by-containment-path-and-sublevel-type.py";
    public static final String GET_OBJECT_BY_CONTAINMENT_PATH_AND_SUBLEVEL_TYPE_SCRIPT_NAMES_ONLY = "com/xebialabs/deployit/plugin/was/step/get-object-by-containment-path-and-sublevel-type-names-only.py";
    public static final String GET_OBJECT_BY_CONTAINMENT_PATH_AND_SUBLEVEL_NAME_SCRIPT = "com/xebialabs/deployit/plugin/was/step/get-object-by-containment-path-and-sublevel-name.py";
    public static final String GET_OBJECT_BY_CONTAINMENT_PATH_AND_SUBLEVEL_TYPE_AND_NAME_SCRIPT = "com/xebialabs/deployit/plugin/was/step/get-object-by-containment-path-and-sublevel-type-and-name.py";
    public static final String GET_CELL_PROPERTIES_PATH_SCRIPT = "com/xebialabs/deployit/plugin/was/step/get-cell-properties.py";
    public static final String GET_OBJECT_BY_ID_SCRIPT = "com/xebialabs/deployit/plugin/was/step/get-object-by-id.py";
    public static final String DISABLE_DAEMON = "com.xebialabs.deployit.plugin.was.disableDaemon";
    private static final String DAEMON_STARTED = "DEPLOYIT-DAEMON-STARTED";
    private static final String DAEMON_EXIT_CODE_MARKER = "DEPLOYIT-DAEMON-EXIT-VALUE: ";
    private static final String DAEMON_END_OF_COMMAND_MARKER = "DEPLOYIT-DAEMON-END-OF-COMMAND";
    private static final String CONFIG_DIR_NAME = "config";
    private static final String PLUGIN_FILENAME = "plugin-cfg.xml";
    private WasCell cell;
    private static final Logger logger = LoggerFactory.getLogger(WasCellConfigurationExecutor.class);

    public WasCellConfigurationExecutor(WasCell cell) {
        this.cell = cell;
    }

    public Host getCellHost() {
        return this.cell.getCellHost();
    }

    public String getConfigDirPath() {
        String fileSep = this.getCellHost().getOperatingSystemFamily().getFileSeparator();
        return this.cell.getWasHome() + fileSep + CONFIG_DIR_NAME;
    }

    public String getWsadminPath() {
        return this.getCommandPath("wsadmin");
    }

    public String getVersionInfoPath() {
        return this.getCommandPath("versionInfo");
    }

    public String getStartServerPath() {
        return this.getCommandPath("startServer");
    }

    public String getStopServerPath() {
        return this.getCommandPath("stopServer");
    }

    public String getServerStatusPath() {
        return this.getCommandPath("serverStatus");
    }

    private String getCommandPath(String command) {
        String fileSep = this.getCellHost().getOperatingSystemFamily().getFileSeparator();
        return this.cell.getWasHome() + fileSep + "bin" + fileSep + command + this.getCellHost().getOperatingSystemFamily().getScriptExtension();
    }

    public String getPluginFilePath() {
        String fileSep = this.getCellHost().getOperatingSystemFamily().getFileSeparator();
        return this.getConfigDirPath() + fileSep + "cells" + fileSep + PLUGIN_FILENAME;
    }

    public HostSession connectToAdminHost() {
        return this.getCellHost().getHostSession();
    }

    public int executeWsadminJythonScript(StepExecutionContext ctx, HostSession cellHostSession, String scriptPath, String ... args) {
        HostFile invokingPyFile = this.createInvokingPyFile(cellHostSession, scriptPath, args);
        String disableDaemon = System.getProperty(DISABLE_DAEMON);
        if (disableDaemon == null) {
            return this.executeWsadminJythonScriptWithDaemon(ctx, cellHostSession, invokingPyFile);
        }
        return this.executeWsadminJythonScriptDirectly((CommandExecutionCallbackHandler)new StepExecutionContextCallbackHandler(ctx), cellHostSession, invokingPyFile);
    }

    private HostFile createInvokingPyFile(HostSession cellHostSession, String scriptPath, String ... args) {
        StringBuffer invokingPyContents = new StringBuffer();
        invokingPyContents.append("import sys;\r\nsys.argv=[");
        boolean first = true;
        for (String arg : args) {
            if (!first) {
                invokingPyContents.append(",");
            } else {
                first = false;
            }
            invokingPyContents.append("'");
            invokingPyContents.append(arg);
            invokingPyContents.append("'");
        }
        invokingPyContents.append("];\r\nexecfile('");
        invokingPyContents.append(scriptPath);
        invokingPyContents.append("')\r\n");
        HostFile invokingPyFile = cellHostSession.getTempFile(FilenameUtils.getBaseName((String)scriptPath), "-invoker.py");
        HostFileUtils.putStringToHostFile((String)invokingPyContents.toString(), (HostFile)invokingPyFile);
        return invokingPyFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeWsadminJythonScriptWithDaemon(final StepExecutionContext ctx, HostSession cellHostSession, HostFile invokingPyFile) {
        CommandExecution wsadminExecution = this.getWsadminDaemonCommandExecution(ctx);
        if (wsadminExecution == null) {
            logger.warn("Cannot create wsadmin daemon session, executing script directly");
            return this.executeWsadminJythonScriptDirectly((CommandExecutionCallbackHandler)new StepExecutionContextCallbackHandler(ctx), cellHostSession, invokingPyFile);
        }
        String daemonLine = "execfile('" + invokingPyFile.getPath() + "')\r\n";
        OutputStream stdin = wsadminExecution.getStdin();
        stdin.write(daemonLine.getBytes());
        stdin.flush();
        BufferedReader stdout = new BufferedReader(new InputStreamReader(wsadminExecution.getStdout()));
        final BufferedReader stderr = new BufferedReader(new InputStreamReader(wsadminExecution.getStderr()));
        Thread stderrThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String stderrLine;
                    while (!Thread.interrupted() && (stderrLine = stderr.readLine()) != null) {
                        ctx.logError(stderrLine);
                    }
                }
                catch (InterruptedIOException ie) {
                }
                catch (IOException exc) {
                    exc.printStackTrace();
                }
            }
        }, "stderr printer for wsadmin daemon running on " + this);
        stderrThread.start();
        try {
            int exitCode = 0;
            while (true) {
                String stdoutLine;
                if ((stdoutLine = stdout.readLine()) == null) {
                    throw new RuntimeIOException("Cannot execute script " + invokingPyFile.getPath() + " on " + this.getCellHost() + ": lost connection to the wsadmin daemon");
                }
                if (stdoutLine.startsWith(DAEMON_EXIT_CODE_MARKER)) {
                    try {
                        exitCode = Integer.parseInt(stdoutLine.substring(DAEMON_EXIT_CODE_MARKER.length()));
                    }
                    catch (NumberFormatException ignored) {}
                    continue;
                }
                if (stdoutLine.equals(DAEMON_END_OF_COMMAND_MARKER)) break;
                ctx.logOutput(stdoutLine);
            }
            int n = exitCode;
            stderrThread.interrupt();
            return n;
        }
        catch (Throwable throwable) {
            try {
                stderrThread.interrupt();
                throw throwable;
            }
            catch (IOException exc) {
                throw new RuntimeIOException("Cannot execute script " + invokingPyFile.getPath() + " on " + this.getCellHost(), (Throwable)exc);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CommandExecution getWsadminDaemonCommandExecution(StepExecutionContext context) {
        String key = "CELL_SESSION_" + this.cell;
        WsadminDaemonExecution wrappedExecution = (WsadminDaemonExecution)context.getAttribute(key);
        if (wrappedExecution == null) {
            HostFile uploadedDaemon;
            String[] cmdArray;
            HostSession daemonSession = this.connectToAdminHost();
            CommandExecution daemonExecution = daemonSession.startExecute(cmdArray = this.buildWsadminCommandLine(uploadedDaemon = daemonSession.copyToTemporaryFile((Resource)new ClassPathResource("com/xebialabs/deployit/plugin/was/step/daemon.py"))));
            if (daemonExecution == null) {
                daemonSession.close();
                return null;
            }
            BufferedReader stdout = new BufferedReader(new InputStreamReader(daemonExecution.getStdout()));
            try {
                String stdoutLine;
                do {
                    if ((stdoutLine = stdout.readLine()) == null) {
                        throw new RuntimeIOException("Cannot start wsadmin daemon: lost connection to the wsadmin daemon");
                    }
                    context.logOutput(stdoutLine);
                } while (!stdoutLine.startsWith(DAEMON_STARTED));
            }
            catch (IOException exc) {
                throw new RuntimeIOException("Cannot start wsadmin daemon", (Throwable)exc);
            }
            wrappedExecution = new WsadminDaemonExecution(daemonSession, daemonExecution);
            context.setAttribute(key, (Object)wrappedExecution);
        }
        return wrappedExecution.getCommandExecution();
    }

    public int executeWsadminJythonScriptDirectly(CommandExecutionCallbackHandler handler, HostSession s, HostFile invokingPyFile) {
        String[] cmdArray = this.buildWsadminCommandLine(invokingPyFile);
        return s.execute(handler, cmdArray);
    }

    private String[] buildWsadminCommandLine(HostFile pyFile) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.getWsadminPath());
        if (StringUtils.isNotBlank((String)this.cell.getUsername())) {
            cmd.add("-user");
            cmd.add(this.cell.getUsername());
            if (!StringUtils.isEmpty((String)this.cell.getPassword())) {
                cmd.add("-password");
                cmd.add(this.cell.getPassword());
            }
        }
        if (this.cell.getPort() != 0) {
            cmd.add("-port");
            cmd.add(Integer.toString(this.cell.getPort()));
        }
        cmd.add("-lang");
        cmd.add("jython");
        cmd.add("-f");
        cmd.add(pyFile.getPath());
        return cmd.toArray(new String[cmd.size()]);
    }

    public Map<String, String> getCellPropertiesInfo(StepExecutionContext ctx) {
        return this.getObjectInfo(ctx, null, null, null, false);
    }

    public Map<String, String> getObjectInfo(StepExecutionContext ctx, String objectContainmentPath) {
        return this.getObjectInfo(ctx, objectContainmentPath, null, null, false);
    }

    public Map<String, String> getObjectInfoWithSubLevelByType(StepExecutionContext ctx, String objectContainmentPath, String subLevelType) {
        return this.getObjectInfo(ctx, objectContainmentPath, subLevelType, null, false);
    }

    public Collection<String> getObjectInfoWithSubLevelByTypeNamesOnly(StepExecutionContext ctx, String objectContainmentPath, String subLevelType) {
        Map<String, String> map = this.getObjectInfo(ctx, objectContainmentPath, subLevelType, null, true);
        if (map == null) {
            return null;
        }
        return map.values();
    }

    public Map<String, String> getObjectInfoWithSubLevelByName(StepExecutionContext ctx, String objectContainmentPath, String subLevelName) {
        return this.getObjectInfo(ctx, objectContainmentPath, null, subLevelName, false);
    }

    public Map<String, String> getObjectInfoWithSubLevelByTypeAndName(StepExecutionContext ctx, String objectContainmentPath, String subLevelType, String subLevelName) {
        return this.getObjectInfo(ctx, objectContainmentPath, subLevelType, subLevelName, false);
    }

    private Map<String, String> getObjectInfo(StepExecutionContext ctx, String objectContainmentPath, String subLevelType, String subLevelName, boolean namesOnly) {
        String[] args;
        String scriptResourcePath;
        if (subLevelType == null) {
            if (subLevelName == null) {
                if (objectContainmentPath == null) {
                    scriptResourcePath = GET_CELL_PROPERTIES_PATH_SCRIPT;
                    args = new String[]{};
                } else {
                    scriptResourcePath = GET_OBJECT_BY_CONTAINMENT_PATH_SCRIPT;
                    args = new String[]{objectContainmentPath};
                }
            } else {
                scriptResourcePath = GET_OBJECT_BY_CONTAINMENT_PATH_AND_SUBLEVEL_NAME_SCRIPT;
                args = new String[]{objectContainmentPath, subLevelName};
            }
        } else if (subLevelName == null) {
            scriptResourcePath = namesOnly ? GET_OBJECT_BY_CONTAINMENT_PATH_AND_SUBLEVEL_TYPE_SCRIPT_NAMES_ONLY : GET_OBJECT_BY_CONTAINMENT_PATH_AND_SUBLEVEL_TYPE_SCRIPT;
            args = new String[]{objectContainmentPath, subLevelType};
        } else {
            scriptResourcePath = GET_OBJECT_BY_CONTAINMENT_PATH_AND_SUBLEVEL_TYPE_AND_NAME_SCRIPT;
            args = new String[]{objectContainmentPath, subLevelType, subLevelName};
        }
        return this.getObjectInfo(ctx, scriptResourcePath, args);
    }

    public Map<String, String> getObjectInfoById(StepExecutionContext ctx, String objectId) {
        return this.getObjectInfo(ctx, GET_OBJECT_BY_ID_SCRIPT, objectId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getObjectInfo(final StepExecutionContext ctx, String scriptResourcePath, String ... args) {
        final HashMap<String, String> mapped = new HashMap<String, String>();
        StepExecutionContext capturingPassthruContext = new StepExecutionContext(){
            private int nodes = 0;
            private int clusters = 0;
            private int servers = 0;

            public void logOutput(String line) {
                ctx.logOutput(line);
                int offset = 0;
                String[] args = RegexUtils.regexMatch(line, "\\[(\\w+)\\ (.*)\\]");
                if (args != null) {
                    String[] betweenQuotes = RegexUtils.regexMatch(args[1], "\"(.*)\"");
                    if (betweenQuotes != null) {
                        mapped.put(args[0], betweenQuotes[0]);
                    } else if (!args[1].equals("[]")) {
                        mapped.put(args[0], args[1]);
                    } else {
                        mapped.put(args[0], "");
                    }
                } else if (line.indexOf("|node.xml#") != -1) {
                    ++this.nodes;
                    if (line.startsWith("\"") && line.endsWith("\"")) {
                        offset = 1;
                    }
                    mapped.put("node_" + this.nodes, line.substring(offset, line.indexOf(40)));
                } else if (line.indexOf("|server.xml#") != -1) {
                    ++this.servers;
                    if (line.startsWith("\"") && line.endsWith("\"")) {
                        offset = 1;
                    }
                    mapped.put("server_" + this.servers, line.substring(offset, line.indexOf(40)));
                } else if (line.indexOf("|cluster.xml#") != -1) {
                    if (line.startsWith("\"") && line.endsWith("\"")) {
                        offset = 1;
                    }
                    ++this.clusters;
                    mapped.put("cluster_" + this.clusters, line.substring(offset, line.indexOf(40)));
                }
            }

            public void logError(String line) {
                ctx.logError(line);
            }

            public void logError(String error, Throwable t) {
                ctx.logError(error, t);
            }

            public Object getAttribute(String name) {
                return ctx.getAttribute(name);
            }

            public void setAttribute(String name, Object object) {
                ctx.setAttribute(name, object);
            }
        };
        HostSession s = this.connectToAdminHost();
        try {
            String scriptPath = s.copyToTemporaryFile((Resource)new ClassPathResource(scriptResourcePath)).getPath();
            int res = this.executeWsadminJythonScript(capturingPassthruContext, s, scriptPath, args);
            if (res != 0) {
                Map<String, String> map = null;
                return map;
            }
            HashMap<String, String> hashMap = mapped;
            return hashMap;
        }
        finally {
            s.close();
        }
    }

    public static final class WsadminDaemonExecution
    implements StepExecutionContextListener {
        private HostSession session;
        private CommandExecution execution;

        public WsadminDaemonExecution(HostSession session, CommandExecution execution) {
            this.session = session;
            this.execution = execution;
        }

        public CommandExecution getCommandExecution() {
            return this.execution;
        }

        public void contextDestroyed() {
            OutputStream stdin = this.execution.getStdin();
            try {
                stdin.write("QUIT\r\n".getBytes());
                stdin.flush();
                this.execution.waitFor();
            }
            catch (IOException exc) {
                logger.error("Error stopping wsadmin daemon", (Throwable)exc);
            }
            catch (RuntimeException exc) {
                logger.error("Error stopping wsadmin daemon", (Throwable)exc);
            }
            this.session.close();
        }
    }
}

