/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.runbook;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.RunBook;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.plugin.was.ci.WasUnmanagedServer;
import com.xebialabs.deployit.plugin.was.step.ModifyWasServerStep;
import com.xebialabs.deployit.plugin.was.step.StartWasUnmanagedServerStep;
import com.xebialabs.deployit.plugin.was.step.StopWasUnmanagedServerStep;

/**
 * Supports the creation, modification and deletion of a {@link com.xebialabs.deployit.plugin.was.ci.WasUnmanagedServer WAS Server}.
 * 
 * <h4>Conditions</h4>
 * 
 * Will trigger if the change plan contains the addition, modification or deletion of a {@link WasUnmanagedServer WAS Server} CI.
 * 
 * <h4>Actions</h4>
 * 
 * Modification:
 * 
 * <ol>
 * <li>The server is started
 * <li>Modify server
 * <li>Stop server
 * <li>Start server
 * </ol>
 */
public class WasUnmanagedServerRunBook extends WasServerRunBook<WasUnmanagedServer> implements RunBook {

	public WasUnmanagedServerRunBook() {
		super(WasUnmanagedServer.class);
	}

	@Override
	protected boolean isEligibleChange(Change<WasUnmanagedServer> change, ChangePlan changePlan) {
		return true;		
	}
	
	@Override
	protected void getStepsForDeletedServer(List<Step> steps, WasUnmanagedServer oldServer) {
		// do nothing
	}

	@Override
	protected void getStepsForModifiedServer(List<Step> steps, WasUnmanagedServer oldServer, WasUnmanagedServer newServer) {
		steps.add(new StartWasUnmanagedServerStep(oldServer));
		steps.add(new ModifyWasServerStep(newServer));
		steps.add(new StopWasUnmanagedServerStep(newServer));
		steps.add(new StartWasUnmanagedServerStep(newServer));
	}

	@Override
	protected void getStepsForAddedServer(List<Step> steps, WasUnmanagedServer newServer) {
		// do nothing
	}
}
