/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.ci;

import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.Discoverable;
import com.xebialabs.deployit.plugin.apache.httpd.ci.ApacheHttpdServer;
import com.xebialabs.deployit.plugin.was.ci.WasNode;
import com.xebialabs.deployit.plugin.was.ci.WebServerVendorType;
import java.util.Map;

@ConfigurationItem(discoverable=true)
public class WasManagedApacheHttpdServer
extends ApacheHttpdServer
implements Discoverable<WasManagedApacheHttpdServer> {
    @ConfigurationItemProperty(required=true)
    private String name;
    @ConfigurationItemProperty(required=true, description="The WAS node on which Apache is installed.")
    private WasNode node;
    @ConfigurationItemProperty(required=true, description="The directory where the WebSphere plugin for Apache has been installed.", size=ConfigurationItemProperty.Size.LARGE)
    private String pluginInstallationDirPath;
    @ConfigurationItemProperty(required=false, description="The path of the WebSphere plugin configuration file. Defaults to <pluginInstallationDirPath>/config/<webservername>/plugin-cfg.xml")
    private String pluginConfigurationPath;
    @ConfigurationItemProperty(required=true, description="The port where the Apache HTTPD server is running on. e.g. 80, 443")
    private int port;
    @ConfigurationItemProperty(required=true, label="Type", description="The Web server vendor type.")
    private WebServerVendorType webServerVendorType = WebServerVendorType.APACHE;

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WasNode getNode() {
        return this.node;
    }

    public void setNode(WasNode node) {
        this.node = node;
    }

    public String getPluginInstallationDirPath() {
        return this.pluginInstallationDirPath;
    }

    public void setPluginInstallationDirPath(String pluginInstallationDirPath) {
        this.pluginInstallationDirPath = pluginInstallationDirPath;
    }

    public String getPluginConfigurationPath() {
        return this.pluginConfigurationPath;
    }

    public void setPluginConfigurationPath(String pluginConfigurationPath) {
        this.pluginConfigurationPath = pluginConfigurationPath;
    }

    public void setWebServerVendorType(WebServerVendorType webServerVendorType) {
        this.webServerVendorType = webServerVendorType;
    }

    public WebServerVendorType getWebServerVendorType() {
        return this.webServerVendorType;
    }

    public String getApacheHttpdServerConfigFragmentPath() {
        String fileSeparator = this.getHost().getFileSeparator();
        return this.getConfigurationLocation() + fileSeparator + "was_" + this.getName() + ".conf";
    }

    public String getApacheHttpdServerConfigFragmentContent() {
        return "WebSpherePluginConfig " + this.getPluginCfgOnRemoteServerPath();
    }

    public String getPluginCfgInWasConfigurationPath() {
        return this.getNode().getCell().getWasHome() + "/config/cells/" + this.getNode().getCell().getCellName() + "/nodes/" + this.getNode().getNodeName() + "/servers/" + this.getName().trim() + "/plugin-cfg.xml";
    }

    public String getPluginCfgOnRemoteServerPath() {
        if (this.pluginConfigurationPath != null) {
            return this.pluginConfigurationPath;
        }
        String fileSeparator = this.getHost().getFileSeparator();
        return this.getPluginInstallationDirPath() + fileSeparator + "config" + fileSeparator + this.getName() + fileSeparator + "plugin-cfg.xml";
    }

    public WasManagedApacheHttpdServer discover(Map<String, Object> info, ChangePlan cp) {
        return this;
    }

    public WasManagedApacheHttpdServer discoverChildrenInfo(Map<String, Object> info, ChangePlan cp) {
        return null;
    }
}

