/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.container;

import static java.util.Collections.emptySet;

import java.util.Collections;
import java.util.List;
import java.util.Set;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.python.DerivedProperty;

/**
 * An unmanaged WebSphere Application Server.
 */
@SuppressWarnings("serial")
@Metadata(description = "An unmanaged WebSphere Applicaton Server (WAS Base/SA)")
public class UnmanagedServer extends BaseCell implements Node, Server, WasAppContainer {

	@Property(required = true, label = "WebSphere cell name", description = "Name of the WebSphere cell, e.g. MyCell, WASCell, Cell01")
	private String cellName;

    @Property(required = true, label = "WebSphere node name", description = "Name of the WebSphere node")
    private String nodeName;

	@Override
	public String getCellName() {
		return cellName;
	}

	public void setCellName(String cellName) {
		this.cellName = cellName;
	}

	@Override
	@DerivedProperty("nodeName")
    public String getNodeName() {
        return nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    @Override
    public Set<Node> getNodes() {
        return emptySet();
    }

    @Override
    public List<String> getApplicationManagerObjectNames() {
        String appMgrObjectName = "cell=" + getCellName() + ",node=" + getNodeName() + ",type=ApplicationManager,process=" + getName() + ",*";
        return Collections.singletonList(appMgrObjectName);
    }

	@Override
    public String getContainmentPath() {
	    return "/Server:" + getName();
    }

    @Override
    public String getWasConfigIdType() {
        return "Server";
    }

    @Override
    public String getWasTargetType() {
        return "server";
    }

    @Override
    public String getShortTypeDescription() {
        return "unmanaged server";
    }

}
