package com.xebialabs.deployit.plugin.was.step;

import static com.xebialabs.overthere.util.CapturingOverthereProcessOutputHandler.capturingHandler;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.xebialabs.deployit.plugin.api.inspection.InspectionExecutionContext;
import com.xebialabs.deployit.plugin.api.inspection.InspectionStep;
import com.xebialabs.deployit.plugin.was.container.BaseCell;
import com.xebialabs.deployit.plugin.was.container.Cell;
import com.xebialabs.deployit.plugin.was.container.WasVersion;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.util.CapturingOverthereProcessOutputHandler;

@SuppressWarnings("serial")
public class GetWasVersionStep implements InspectionStep {

	private Cell cell;

	public GetWasVersionStep(Cell cell) {
		this.cell = cell;
	}

	@Override
	public com.xebialabs.deployit.plugin.api.execution.Step.Result execute(InspectionExecutionContext ctx) throws Exception {
		OverthereConnection adminConnection = cell.getHost().getConnection();
		try {
			CapturingOverthereProcessOutputHandler capturedOutput = capturingHandler();
			int res = adminConnection.execute(capturedOutput, CmdLine.build(cell.getVersionInfoPath()));
			if (res != 0) {
				ctx.logError("Non-zero exitcode from " + cell.getVersionInfoPath() + ": " + res);
				return Result.Fail;
			}

			for (String eachLine : capturedOutput.getOutputLines()) {
				if (eachLine.startsWith("Version")) {
					String[] matches = regexMatch(eachLine, "Version\\s+(\\d+)\\.(\\d+)\\.[\\d\\.]*");
					if (matches != null && matches.length == 2) {
						int majorVersion = Integer.parseInt(matches[0]);
						int minorVersion = Integer.parseInt(matches[1]);

						if (majorVersion == 6 && minorVersion == 1) {
							((BaseCell) cell).setVersion(WasVersion.WAS_61);
						} else if (majorVersion == 7 && minorVersion == 0) {
							((BaseCell) cell).setVersion(WasVersion.WAS_70);
						} else if (majorVersion == 8 && minorVersion == 0) {
							((BaseCell) cell).setVersion(WasVersion.WAS_80);
						} else {
							ctx.logError("Cannot set version on " + cell + ": version " + majorVersion + "." + minorVersion + " is not supported");
							return Result.Fail;
						}
						return Result.Success;
					}
				}
			}
			ctx.logError("Could not determine installed version of " + cell);
			return Result.Fail;
		} finally {
			adminConnection.close();
		}
	}

	@Override
	public String getDescription() {
		return "Get version of " + cell;
	}

	private static String[] regexMatch(String str, String regexPattern) {
		Matcher m = Pattern.compile(regexPattern).matcher(str);
		if (m.matches()) {
			String[] matches = new String[m.groupCount()];
			for (int i = 0; i < matches.length; i++) {
				matches[i] = m.group(i + 1);
			}
			return matches;
		} else {
			return null;
		}
	}

}
