/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.container;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.was.container.NodeAgent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class NodeSynchronizer {
    @Contributor
    public void syncNodes(Deltas deltas, DeploymentPlanningContext ctx) {
        Multimap<Integer, NodeAgent> nodesToSync = NodeSynchronizer.getNodesToSync(ctx);
        Iterator i$ = nodesToSync.keySet().iterator();
        while (i$.hasNext()) {
            int order = (Integer)i$.next();
            for (NodeAgent node : nodesToSync.get((Object)order)) {
                HashMap pythonVars = Maps.newHashMap();
                pythonVars.put("nodeName", node.getNodeName());
                ctx.addStep((DeploymentStep)new PythonDeploymentStep(order, (PythonManagingContainer)node.getCell(), node.getSynchronizeScript(), (Map)pythonVars, "Synchronize " + node.getName()));
            }
        }
        nodesToSync.clear();
    }

    private static Multimap<Integer, NodeAgent> getNodesToSync(DeploymentPlanningContext ctx) {
        Multimap nodesToSync = (Multimap)ctx.getAttribute("was.nodesToSync");
        if (nodesToSync == null) {
            nodesToSync = HashMultimap.create();
            ctx.setAttribute("was.nodesToSync", (Object)nodesToSync);
        }
        return nodesToSync;
    }

    public static void addNodeToSync(DeploymentPlanningContext ctx, int order, NodeAgent n) {
        NodeSynchronizer.getNodesToSync(ctx).put((Object)order, (Object)n);
    }
}

